@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property excludes The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
 * @property includes The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaArgs(
    public val excludes: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgs>? = null,
    public val includes: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaArgs.builder()
            .excludes(excludes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includes(includes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketCriteriaArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketCriteriaArgsBuilder internal constructor() {
    private var excludes: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgs>? = null

    private var includes: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs>? = null

    /**
     * @param value The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
     */
    @JvmName("bmqptioanwblywth")
    public suspend fun excludes(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgs>) {
        this.excludes = value
    }

    /**
     * @param value The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
     */
    @JvmName("bcpggmrxltdrawoh")
    public suspend fun includes(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs>) {
        this.includes = value
    }

    /**
     * @param value The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
     */
    @JvmName("wyvoxkmyjgintvbr")
    public suspend fun excludes(`value`: ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludes = mapped
    }

    /**
     * @param argument The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
     */
    @JvmName("dfwvllkrbnbtwwma")
    public suspend fun excludes(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.excludes = mapped
    }

    /**
     * @param value The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
     */
    @JvmName("qgucgxtshmmtmyog")
    public suspend fun includes(`value`: ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includes = mapped
    }

    /**
     * @param argument The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
     */
    @JvmName("kehkstvmtcswouwp")
    public suspend fun includes(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.includes = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketCriteriaArgs =
        ClassificationJobS3JobDefinitionBucketCriteriaArgs(
            excludes = excludes,
            includes = includes,
        )
}
