@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparator The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
 * @property tagValues The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs(
    public val comparator: Output<String>? = null,
    public val tagValues: Output<List<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs.builder()
            .comparator(comparator?.applyValue({ args0 -> args0 }))
            .tagValues(
                tagValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgsBuilder
internal constructor() {
    private var comparator: Output<String>? = null

    private var tagValues:
        Output<List<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>>? =
        null

    /**
     * @param value The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
     */
    @JvmName("bmiflmymkqxcresr")
    public suspend fun comparator(`value`: Output<String>) {
        this.comparator = value
    }

    /**
     * @param value The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("neodltqiwsjsdeip")
    public suspend fun tagValues(`value`: Output<List<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>>) {
        this.tagValues = value
    }

    @JvmName("aghfytdvidpjlrkn")
    public suspend fun tagValues(vararg values: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>) {
        this.tagValues = Output.all(values.asList())
    }

    /**
     * @param values The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("xchagajpkqchkceo")
    public suspend fun tagValues(values: List<Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>>) {
        this.tagValues = Output.all(values)
    }

    /**
     * @param value The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
     */
    @JvmName("uwodhqxframlvsii")
    public suspend fun comparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparator = mapped
    }

    /**
     * @param value The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("ukawutnhhoxjhrri")
    public suspend fun tagValues(`value`: List<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param argument The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("jtmtjouqhvabaejg")
    public suspend fun tagValues(argument: List<suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("srwmemqcekhfexql")
    public suspend fun tagValues(vararg argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("bkfajsvxyvtqdqal")
    public suspend fun tagValues(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param values The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
     */
    @JvmName("dpvborstvawjnyfn")
    public suspend fun tagValues(vararg values: ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs =
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs(
            comparator = comparator,
            tagValues = tagValues,
        )
}
