@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs(
    public val ands: Output<List<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs.builder()
            .ands(
                ands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgsBuilder internal constructor() {
    private var ands: Output<List<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>>? =
        null

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("gmaskgrxfkqovkoa")
    public suspend fun ands(`value`: Output<List<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>>) {
        this.ands = value
    }

    @JvmName("efeavajoniivjjcw")
    public suspend fun ands(vararg values: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("eqxumtdkvtqnrijy")
    public suspend fun ands(values: List<Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("ddmremwwxawywpis")
    public suspend fun ands(`value`: List<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("dboikjmniqaquuvs")
    public suspend fun ands(argument: List<suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("aetbhyiwyqwcwmuv")
    public suspend fun ands(vararg argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("gnhqhmgqdnvcxsgp")
    public suspend fun ands(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("jmqvwouutoqfyqnu")
    public suspend fun ands(vararg values: ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs =
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs(
            ands = ands,
        )
}
