@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparator The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
 * @property key The object property to use in the condition.
 * @property values An array that lists the values to use in the condition.
 */
public data class ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs(
    public val comparator: Output<String>? = null,
    public val key: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs.builder()
            .comparator(comparator?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgsBuilder internal constructor() {
    private var comparator: Output<String>? = null

    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
     */
    @JvmName("mgpnkvhlrwjbsnmu")
    public suspend fun comparator(`value`: Output<String>) {
        this.comparator = value
    }

    /**
     * @param value The object property to use in the condition.
     */
    @JvmName("hitblogrmtunsshl")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value An array that lists the values to use in the condition.
     */
    @JvmName("cadujkjasvyxmtrq")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("ghbdnfyfribdsqyd")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values An array that lists the values to use in the condition.
     */
    @JvmName("qmhkafqeeibljfhe")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
     */
    @JvmName("mltweqygnjqgiocy")
    public suspend fun comparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparator = mapped
    }

    /**
     * @param value The object property to use in the condition.
     */
    @JvmName("hwjfgmiqtkvevwjg")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value An array that lists the values to use in the condition.
     */
    @JvmName("kcbworhgkhfnlmwt")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values An array that lists the values to use in the condition.
     */
    @JvmName("rwfkqjfndapbxftg")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs =
        ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs(
            comparator = comparator,
            key = key,
            values = values,
        )
}
