@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparator The operator to use in the condition.
 * @property key The tag key to use in the condition. The only valid value is `TAG`.
 * @property tagValues The tag keys or tag key and value pairs to use in the condition.
 * @property target The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
 */
public data class ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs(
    public val comparator: Output<String>? = null,
    public val key: Output<String>? = null,
    public val tagValues: Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>>? =
        null,
    public val target: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs.builder()
            .comparator(comparator?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .tagValues(
                tagValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgsBuilder internal constructor() {
    private var comparator: Output<String>? = null

    private var key: Output<String>? = null

    private var tagValues:
        Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>>? =
        null

    private var target: Output<String>? = null

    /**
     * @param value The operator to use in the condition.
     */
    @JvmName("slwoetctdorimttp")
    public suspend fun comparator(`value`: Output<String>) {
        this.comparator = value
    }

    /**
     * @param value The tag key to use in the condition. The only valid value is `TAG`.
     */
    @JvmName("wnevrochbwpyjhbi")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("tlyijegtotgdnuiu")
    public suspend fun tagValues(`value`: Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>>) {
        this.tagValues = value
    }

    @JvmName("betncttgbfisfsax")
    public suspend fun tagValues(vararg values: Output<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>) {
        this.tagValues = Output.all(values.asList())
    }

    /**
     * @param values The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("rugmirpfhwblcapp")
    public suspend fun tagValues(values: List<Output<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>>) {
        this.tagValues = Output.all(values)
    }

    /**
     * @param value The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
     */
    @JvmName("vlnpegenfewkudfn")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The operator to use in the condition.
     */
    @JvmName("fahuxquwtvfyfjfb")
    public suspend fun comparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparator = mapped
    }

    /**
     * @param value The tag key to use in the condition. The only valid value is `TAG`.
     */
    @JvmName("dqrakpvbawblbiab")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("ohuabemxkujfneiq")
    public suspend fun tagValues(`value`: List<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("cokwrmnvwoetqqqo")
    public suspend fun tagValues(argument: List<suspend ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("jdssjgapejnbbouf")
    public suspend fun tagValues(vararg argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("lutrjaqnbkyudloa")
    public suspend fun tagValues(argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param values The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("qwbjqmjtixywdncw")
    public suspend fun tagValues(vararg values: ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param value The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
     */
    @JvmName("tunsflkifxwtyosu")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs =
        ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs(
            comparator = comparator,
            key = key,
            tagValues = tagValues,
            target = target,
        )
}
