@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionScopingExcludesArgs(
    public val ands: Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesArgs.builder()
            .ands(
                ands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingExcludesArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingExcludesArgsBuilder internal constructor() {
    private var ands: Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>>? = null

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("akiaueqjhlexholh")
    public suspend fun ands(`value`: Output<List<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>>) {
        this.ands = value
    }

    @JvmName("tnuslgjyfyikcvns")
    public suspend fun ands(vararg values: Output<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("inymoanvpeegerfn")
    public suspend fun ands(values: List<Output<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("wcxyhuymxithjbsc")
    public suspend fun ands(`value`: List<ClassificationJobS3JobDefinitionScopingExcludesAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("jdoblkiiknvlwfpg")
    public suspend fun ands(argument: List<suspend ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("vfrwebvgyshsyyan")
    public suspend fun ands(vararg argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("oyyfnbwwwsmbsybm")
    public suspend fun ands(argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("vulcvjnnimvvqviu")
    public suspend fun ands(vararg values: ClassificationJobS3JobDefinitionScopingExcludesAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingExcludesArgs =
        ClassificationJobS3JobDefinitionScopingExcludesArgs(
            ands = ands,
        )
}
