@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property simpleScopeTerm A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
 * @property tagScopeTerm A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionScopingIncludesAndArgs(
    public val simpleScopeTerm: Output<ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgs>? = null,
    public val tagScopeTerm: Output<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndArgs.builder()
            .simpleScopeTerm(simpleScopeTerm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagScopeTerm(tagScopeTerm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingIncludesAndArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder internal constructor() {
    private var simpleScopeTerm:
        Output<ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgs>? = null

    private var tagScopeTerm:
        Output<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs>? = null

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("hlowjhbdvyjkfhrt")
    public suspend fun simpleScopeTerm(`value`: Output<ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgs>) {
        this.simpleScopeTerm = value
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("exslvvgscbgdauyd")
    public suspend fun tagScopeTerm(`value`: Output<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs>) {
        this.tagScopeTerm = value
    }

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("xapbumqagijdnqni")
    public suspend fun simpleScopeTerm(`value`: ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpleScopeTerm = mapped
    }

    /**
     * @param argument A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("ydocfnrvitjfcpgp")
    public suspend fun simpleScopeTerm(argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.simpleScopeTerm = mapped
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("yjxgbbvjbvfegpun")
    public suspend fun tagScopeTerm(`value`: ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagScopeTerm = mapped
    }

    /**
     * @param argument A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("hrejkdjlackjwlls")
    public suspend fun tagScopeTerm(argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tagScopeTerm = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingIncludesAndArgs =
        ClassificationJobS3JobDefinitionScopingIncludesAndArgs(
            simpleScopeTerm = simpleScopeTerm,
            tagScopeTerm = tagScopeTerm,
        )
}
