@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparator The operator to use in the condition.
 * @property key The tag key to use in the condition. The only valid value is `TAG`.
 * @property tagValues The tag keys or tag key and value pairs to use in the condition.
 * @property target The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
 */
public data class ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs(
    public val comparator: Output<String>? = null,
    public val key: Output<String>? = null,
    public val tagValues: Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>>? =
        null,
    public val target: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs.builder()
            .comparator(comparator?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .tagValues(
                tagValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgsBuilder internal constructor() {
    private var comparator: Output<String>? = null

    private var key: Output<String>? = null

    private var tagValues:
        Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>>? =
        null

    private var target: Output<String>? = null

    /**
     * @param value The operator to use in the condition.
     */
    @JvmName("artuhbvvcybgkjfl")
    public suspend fun comparator(`value`: Output<String>) {
        this.comparator = value
    }

    /**
     * @param value The tag key to use in the condition. The only valid value is `TAG`.
     */
    @JvmName("seaukiyaisjuupyc")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("rpqllyfitkkhikda")
    public suspend fun tagValues(`value`: Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>>) {
        this.tagValues = value
    }

    @JvmName("logaeeitgtqeralp")
    public suspend fun tagValues(vararg values: Output<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>) {
        this.tagValues = Output.all(values.asList())
    }

    /**
     * @param values The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("anyuctenyyspfmik")
    public suspend fun tagValues(values: List<Output<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>>) {
        this.tagValues = Output.all(values)
    }

    /**
     * @param value The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
     */
    @JvmName("qctgdqbjvamanqrh")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The operator to use in the condition.
     */
    @JvmName("ruhlwgxfultthdpq")
    public suspend fun comparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparator = mapped
    }

    /**
     * @param value The tag key to use in the condition. The only valid value is `TAG`.
     */
    @JvmName("uafrocycawkmvqll")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("gbxlabfjjutfooek")
    public suspend fun tagValues(`value`: List<ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("wgufpnagmjmnmagq")
    public suspend fun tagValues(argument: List<suspend ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("oxeklumjdologlpy")
    public suspend fun tagValues(vararg argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param argument The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("crvbodbjbsaabjot")
    public suspend fun tagValues(argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.tagValues = mapped
    }

    /**
     * @param values The tag keys or tag key and value pairs to use in the condition.
     */
    @JvmName("uxubmvywugnuehrp")
    public suspend fun tagValues(vararg values: ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param value The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
     */
    @JvmName("gbxfjrdwdlxukudb")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs =
        ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs(
            comparator = comparator,
            key = key,
            tagValues = tagValues,
            target = target,
        )
}
