@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionScopingIncludesArgs(
    public val ands: Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingIncludesArgs.builder()
            .ands(
                ands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingIncludesArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingIncludesArgsBuilder internal constructor() {
    private var ands: Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>>? = null

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("mobqqkudxeobqrio")
    public suspend fun ands(`value`: Output<List<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>>) {
        this.ands = value
    }

    @JvmName("rkguqhkddcnjjfcm")
    public suspend fun ands(vararg values: Output<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("gfqposkwayosiqbo")
    public suspend fun ands(values: List<Output<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("itbshcxtwxcrdqvh")
    public suspend fun ands(`value`: List<ClassificationJobS3JobDefinitionScopingIncludesAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("njkdofxyqthjjvjv")
    public suspend fun ands(argument: List<suspend ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("ehgwmqrnsyfopufc")
    public suspend fun ands(vararg argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("digqmifpqkssgpqo")
    public suspend fun ands(argument: suspend ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionScopingIncludesAndArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
     */
    @JvmName("lsawonprodovcubd")
    public suspend fun ands(vararg values: ClassificationJobS3JobDefinitionScopingIncludesAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingIncludesArgs =
        ClassificationJobS3JobDefinitionScopingIncludesArgs(
            ands = ands,
        )
}
