@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobScheduleFrequencyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dailySchedule Specifies a daily recurrence pattern for running the job.
 * @property monthlySchedule Specifies a monthly recurrence pattern for running the job.
 * @property weeklySchedule Specifies a weekly recurrence pattern for running the job.
 */
public data class ClassificationJobScheduleFrequencyArgs(
    public val dailySchedule: Output<Boolean>? = null,
    public val monthlySchedule: Output<Int>? = null,
    public val weeklySchedule: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobScheduleFrequencyArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobScheduleFrequencyArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobScheduleFrequencyArgs.builder()
            .dailySchedule(dailySchedule?.applyValue({ args0 -> args0 }))
            .monthlySchedule(monthlySchedule?.applyValue({ args0 -> args0 }))
            .weeklySchedule(weeklySchedule?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationJobScheduleFrequencyArgs].
 */
@PulumiTagMarker
public class ClassificationJobScheduleFrequencyArgsBuilder internal constructor() {
    private var dailySchedule: Output<Boolean>? = null

    private var monthlySchedule: Output<Int>? = null

    private var weeklySchedule: Output<String>? = null

    /**
     * @param value Specifies a daily recurrence pattern for running the job.
     */
    @JvmName("nxtawmmhyviaxisa")
    public suspend fun dailySchedule(`value`: Output<Boolean>) {
        this.dailySchedule = value
    }

    /**
     * @param value Specifies a monthly recurrence pattern for running the job.
     */
    @JvmName("pyonslktimluiewy")
    public suspend fun monthlySchedule(`value`: Output<Int>) {
        this.monthlySchedule = value
    }

    /**
     * @param value Specifies a weekly recurrence pattern for running the job.
     */
    @JvmName("thmwggkikkqpwyic")
    public suspend fun weeklySchedule(`value`: Output<String>) {
        this.weeklySchedule = value
    }

    /**
     * @param value Specifies a daily recurrence pattern for running the job.
     */
    @JvmName("jbxkahdofnaadntu")
    public suspend fun dailySchedule(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySchedule = mapped
    }

    /**
     * @param value Specifies a monthly recurrence pattern for running the job.
     */
    @JvmName("sxogmblamnnefclk")
    public suspend fun monthlySchedule(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlySchedule = mapped
    }

    /**
     * @param value Specifies a weekly recurrence pattern for running the job.
     */
    @JvmName("vdylmnkekvhsqmuw")
    public suspend fun weeklySchedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklySchedule = mapped
    }

    internal fun build(): ClassificationJobScheduleFrequencyArgs =
        ClassificationJobScheduleFrequencyArgs(
            dailySchedule = dailySchedule,
            monthlySchedule = monthlySchedule,
            weeklySchedule = weeklySchedule,
        )
}
