@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
 * @property keyPrefix The object key for the bucket in which Amazon Macie exports the data classification results.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 * Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
 */
public data class ClassificationExportConfigurationS3Destination(
    public val bucketName: String,
    public val keyPrefix: String? = null,
    public val kmsKeyArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationExportConfigurationS3Destination): ClassificationExportConfigurationS3Destination =
            ClassificationExportConfigurationS3Destination(
                bucketName = javaType.bucketName(),
                keyPrefix = javaType.keyPrefix().map({ args0 -> args0 }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn(),
            )
    }
}
