@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparator The operator to use in a condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
 * @property key The object property to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionkeyforjob)
 * @property values An array that lists the values to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionforjob)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion(
    public val comparator: String? = null,
    public val key: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion): ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion =
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion(
                comparator = javaType.comparator().map({ args0 -> args0 }).orElse(null),
                key = javaType.key().map({ args0 -> args0 }).orElse(null),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
