@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dailySchedule Specifies a daily recurrence pattern for running the job.
 * @property monthlySchedule Specifies a monthly recurrence pattern for running the job.
 * @property weeklySchedule Specifies a weekly recurrence pattern for running the job.
 */
public data class ClassificationJobScheduleFrequency(
    public val dailySchedule: Boolean? = null,
    public val monthlySchedule: Int? = null,
    public val weeklySchedule: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobScheduleFrequency): ClassificationJobScheduleFrequency = ClassificationJobScheduleFrequency(
            dailySchedule = javaType.dailySchedule().map({ args0 -> args0 }).orElse(null),
            monthlySchedule = javaType.monthlySchedule().map({ args0 -> args0 }).orElse(null),
            weeklySchedule = javaType.weeklySchedule().map({ args0 -> args0 }).orElse(null),
        )
    }
}
