@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin

import com.pulumi.aws.mediaconvert.MediaconvertFunctions.getQueuePlain
import com.pulumi.aws.mediaconvert.kotlin.inputs.GetQueuePlainArgs
import com.pulumi.aws.mediaconvert.kotlin.inputs.GetQueuePlainArgsBuilder
import com.pulumi.aws.mediaconvert.kotlin.outputs.GetQueueResult
import com.pulumi.aws.mediaconvert.kotlin.outputs.GetQueueResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object MediaconvertFunctions {
    /**
     * Retrieve information about a AWS Elemental MediaConvert Queue.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.mediaconvert.getQueue({
     *     id: "tf-example-queue",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.mediaconvert.get_queue(id="tf-example-queue")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MediaConvert.GetQueue.Invoke(new()
     *     {
     *         Id = "tf-example-queue",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mediaconvert"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mediaconvert.LookupQueue(ctx, &mediaconvert.LookupQueueArgs{
     * 			Id: "tf-example-queue",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mediaconvert.MediaconvertFunctions;
     * import com.pulumi.aws.mediaconvert.inputs.GetQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MediaconvertFunctions.getQueue(GetQueueArgs.builder()
     *             .id("tf-example-queue")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:mediaconvert:getQueue
     *       Arguments:
     *         id: tf-example-queue
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQueue.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: GetQueuePlainArgs): GetQueueResult =
        toKotlin(getQueuePlain(argument.toJava()).await())

    /**
     * @see [getQueue].
     * @param id Unique identifier of the queue. The same as `name`.
     * @param tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(id: String, tags: Map<String, String>? = null): GetQueueResult {
        val argument = GetQueuePlainArgs(
            id = id,
            tags = tags,
        )
        return toKotlin(getQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueue].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mediaconvert&#46;kotlin&#46;inputs&#46;GetQueuePlainArgs].
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: suspend GetQueuePlainArgsBuilder.() -> Unit): GetQueueResult {
        val builder = GetQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getQueuePlain(builtArgument.toJava()).await())
    }
}
