@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin

import com.pulumi.aws.mediaconvert.QueueArgs.builder
import com.pulumi.aws.mediaconvert.kotlin.inputs.QueueReservationPlanSettingsArgs
import com.pulumi.aws.mediaconvert.kotlin.inputs.QueueReservationPlanSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Elemental MediaConvert Queue.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.mediaconvert.Queue("test", {name: "tf-test-queue"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.mediaconvert.Queue("test", name="tf-test-queue")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.MediaConvert.Queue("test", new()
 *     {
 *         Name = "tf-test-queue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mediaconvert"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mediaconvert.NewQueue(ctx, "test", &mediaconvert.QueueArgs{
 * 			Name: pulumi.String("tf-test-queue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mediaconvert.Queue;
 * import com.pulumi.aws.mediaconvert.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .name("tf-test-queue")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:mediaconvert:Queue
 *     properties:
 *       name: tf-test-queue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Media Convert Queue using the queue name. For example:
 * ```sh
 * $ pulumi import aws:mediaconvert/queue:Queue test tf-test-queue
 * ```
 * @property description A description of the queue
 * @property name A unique identifier describing the queue
 * @property pricingPlan Specifies whether the pricing plan for the queue is on-demand or reserved. Valid values are `ON_DEMAND` or `RESERVED`. Default to `ON_DEMAND`.
 * @property reservationPlanSettings A detail pricing plan of the  reserved queue. See below.
 * @property status A status of the queue. Valid values are `ACTIVE` or `RESERVED`. Default to `PAUSED`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class QueueArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val pricingPlan: Output<String>? = null,
    public val reservationPlanSettings: Output<QueueReservationPlanSettingsArgs>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mediaconvert.QueueArgs> {
    override fun toJava(): com.pulumi.aws.mediaconvert.QueueArgs =
        com.pulumi.aws.mediaconvert.QueueArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pricingPlan(pricingPlan?.applyValue({ args0 -> args0 }))
            .reservationPlanSettings(
                reservationPlanSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var pricingPlan: Output<String>? = null

    private var reservationPlanSettings: Output<QueueReservationPlanSettingsArgs>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the queue
     */
    @JvmName("wrebnohqyyebyvuo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A unique identifier describing the queue
     */
    @JvmName("pjeptjbsncmvsnyt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether the pricing plan for the queue is on-demand or reserved. Valid values are `ON_DEMAND` or `RESERVED`. Default to `ON_DEMAND`.
     */
    @JvmName("udilmtygdnnqvydx")
    public suspend fun pricingPlan(`value`: Output<String>) {
        this.pricingPlan = value
    }

    /**
     * @param value A detail pricing plan of the  reserved queue. See below.
     */
    @JvmName("uvvafvfbvvlyiuau")
    public suspend fun reservationPlanSettings(`value`: Output<QueueReservationPlanSettingsArgs>) {
        this.reservationPlanSettings = value
    }

    /**
     * @param value A status of the queue. Valid values are `ACTIVE` or `RESERVED`. Default to `PAUSED`.
     */
    @JvmName("davjpfofdqvhrixn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yujecrdxfvohxohh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the queue
     */
    @JvmName("qkdnodweixfvcldj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A unique identifier describing the queue
     */
    @JvmName("quwjstgblbapaibw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether the pricing plan for the queue is on-demand or reserved. Valid values are `ON_DEMAND` or `RESERVED`. Default to `ON_DEMAND`.
     */
    @JvmName("lywfwyvoyxjukpqh")
    public suspend fun pricingPlan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingPlan = mapped
    }

    /**
     * @param value A detail pricing plan of the  reserved queue. See below.
     */
    @JvmName("pchguoduxjoonjfb")
    public suspend fun reservationPlanSettings(`value`: QueueReservationPlanSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationPlanSettings = mapped
    }

    /**
     * @param argument A detail pricing plan of the  reserved queue. See below.
     */
    @JvmName("sgfgthihfaggnhas")
    public suspend fun reservationPlanSettings(argument: suspend QueueReservationPlanSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = QueueReservationPlanSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reservationPlanSettings = mapped
    }

    /**
     * @param value A status of the queue. Valid values are `ACTIVE` or `RESERVED`. Default to `PAUSED`.
     */
    @JvmName("bpnjsdwfpqfxtgar")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ebvkoensjsdwllbc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vkkkqidggumsuxui")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        description = description,
        name = name,
        pricingPlan = pricingPlan,
        reservationPlanSettings = reservationPlanSettings,
        status = status,
        tags = tags,
    )
}
