@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getQueue.
 * @property arn The Arn of the queue.
 * @property id
 * @property name The same as `id`.
 * @property status The status of the queue.
 * @property tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 */
public data class GetQueueResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mediaconvert.outputs.GetQueueResult): GetQueueResult = GetQueueResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
