@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.ChannelArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelCdiInputSpecificationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelCdiInputSpecificationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelDestinationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelDestinationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelEncoderSettingsArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelEncoderSettingsArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputAttachmentArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputAttachmentArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputSpecificationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputSpecificationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelMaintenanceArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelMaintenanceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelVpcArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive Channel.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.medialive.Channel("example", {
 *     name: "example-channel",
 *     channelClass: "STANDARD",
 *     roleArn: exampleAwsIamRole.arn,
 *     inputSpecification: {
 *         codec: "AVC",
 *         inputResolution: "HD",
 *         maximumBitrate: "MAX_20_MBPS",
 *     },
 *     inputAttachments: [{
 *         inputAttachmentName: "example-input",
 *         inputId: exampleAwsMedialiveInput.id,
 *     }],
 *     destinations: [{
 *         id: "destination",
 *         settings: [
 *             {
 *                 url: `s3://${main.id}/test1`,
 *             },
 *             {
 *                 url: `s3://${main2.id}/test2`,
 *             },
 *         ],
 *     }],
 *     encoderSettings: {
 *         timecodeConfig: {
 *             source: "EMBEDDED",
 *         },
 *         audioDescriptions: [{
 *             audioSelectorName: "example audio selector",
 *             name: "audio-selector",
 *         }],
 *         videoDescriptions: [{
 *             name: "example-video",
 *         }],
 *         outputGroups: [{
 *             outputGroupSettings: {
 *                 archiveGroupSettings: [{
 *                     destination: {
 *                         destinationRefId: "destination",
 *                     },
 *                 }],
 *             },
 *             outputs: [{
 *                 outputName: "example-name",
 *                 videoDescriptionName: "example-video",
 *                 audioDescriptionNames: ["audio-selector"],
 *                 outputSettings: {
 *                     archiveOutputSettings: {
 *                         nameModifier: "_1",
 *                         extension: "m2ts",
 *                         containerSettings: {
 *                             m2tsSettings: {
 *                                 audioBufferModel: "ATSC",
 *                                 bufferModel: "MULTIPLEX",
 *                                 rateMode: "CBR",
 *                             },
 *                         },
 *                     },
 *                 },
 *             }],
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.medialive.Channel("example",
 *     name="example-channel",
 *     channel_class="STANDARD",
 *     role_arn=example_aws_iam_role["arn"],
 *     input_specification={
 *         "codec": "AVC",
 *         "input_resolution": "HD",
 *         "maximum_bitrate": "MAX_20_MBPS",
 *     },
 *     input_attachments=[{
 *         "input_attachment_name": "example-input",
 *         "input_id": example_aws_medialive_input["id"],
 *     }],
 *     destinations=[{
 *         "id": "destination",
 *         "settings": [
 *             {
 *                 "url": f"s3://{main['id']}/test1",
 *             },
 *             {
 *                 "url": f"s3://{main2['id']}/test2",
 *             },
 *         ],
 *     }],
 *     encoder_settings={
 *         "timecode_config": {
 *             "source": "EMBEDDED",
 *         },
 *         "audio_descriptions": [{
 *             "audio_selector_name": "example audio selector",
 *             "name": "audio-selector",
 *         }],
 *         "video_descriptions": [{
 *             "name": "example-video",
 *         }],
 *         "output_groups": [{
 *             "output_group_settings": {
 *                 "archive_group_settings": [{
 *                     "destination": {
 *                         "destination_ref_id": "destination",
 *                     },
 *                 }],
 *             },
 *             "outputs": [{
 *                 "output_name": "example-name",
 *                 "video_description_name": "example-video",
 *                 "audio_description_names": ["audio-selector"],
 *                 "output_settings": {
 *                     "archive_output_settings": {
 *                         "name_modifier": "_1",
 *                         "extension": "m2ts",
 *                         "container_settings": {
 *                             "m2ts_settings": {
 *                                 "audio_buffer_model": "ATSC",
 *                                 "buffer_model": "MULTIPLEX",
 *                                 "rate_mode": "CBR",
 *                             },
 *                         },
 *                     },
 *                 },
 *             }],
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MediaLive.Channel("example", new()
 *     {
 *         Name = "example-channel",
 *         ChannelClass = "STANDARD",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         InputSpecification = new Aws.MediaLive.Inputs.ChannelInputSpecificationArgs
 *         {
 *             Codec = "AVC",
 *             InputResolution = "HD",
 *             MaximumBitrate = "MAX_20_MBPS",
 *         },
 *         InputAttachments = new[]
 *         {
 *             new Aws.MediaLive.Inputs.ChannelInputAttachmentArgs
 *             {
 *                 InputAttachmentName = "example-input",
 *                 InputId = exampleAwsMedialiveInput.Id,
 *             },
 *         },
 *         Destinations = new[]
 *         {
 *             new Aws.MediaLive.Inputs.ChannelDestinationArgs
 *             {
 *                 Id = "destination",
 *                 Settings = new[]
 *                 {
 *                     new Aws.MediaLive.Inputs.ChannelDestinationSettingArgs
 *                     {
 *                         Url = $"s3://{main.Id}/test1",
 *                     },
 *                     new Aws.MediaLive.Inputs.ChannelDestinationSettingArgs
 *                     {
 *                         Url = $"s3://{main2.Id}/test2",
 *                     },
 *                 },
 *             },
 *         },
 *         EncoderSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsArgs
 *         {
 *             TimecodeConfig = new Aws.MediaLive.Inputs.ChannelEncoderSettingsTimecodeConfigArgs
 *             {
 *                 Source = "EMBEDDED",
 *             },
 *             AudioDescriptions = new[]
 *             {
 *                 new Aws.MediaLive.Inputs.ChannelEncoderSettingsAudioDescriptionArgs
 *                 {
 *                     AudioSelectorName = "example audio selector",
 *                     Name = "audio-selector",
 *                 },
 *             },
 *             VideoDescriptions = new[]
 *             {
 *                 new Aws.MediaLive.Inputs.ChannelEncoderSettingsVideoDescriptionArgs
 *                 {
 *                     Name = "example-video",
 *                 },
 *             },
 *             OutputGroups = new[]
 *             {
 *                 new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupArgs
 *                 {
 *                     OutputGroupSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs
 *                     {
 *                         ArchiveGroupSettings = new[]
 *                         {
 *                             new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs
 *                             {
 *                                 Destination = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs
 *                                 {
 *                                     DestinationRefId = "destination",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     Outputs = new[]
 *                     {
 *                         new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputArgs
 *                         {
 *                             OutputName = "example-name",
 *                             VideoDescriptionName = "example-video",
 *                             AudioDescriptionNames = new[]
 *                             {
 *                                 "audio-selector",
 *                             },
 *                             OutputSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs
 *                             {
 *                                 ArchiveOutputSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs
 *                                 {
 *                                     NameModifier = "_1",
 *                                     Extension = "m2ts",
 *                                     ContainerSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs
 *                                     {
 *                                         M2tsSettings = new Aws.MediaLive.Inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs
 *                                         {
 *                                             AudioBufferModel = "ATSC",
 *                                             BufferModel = "MULTIPLEX",
 *                                             RateMode = "CBR",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := medialive.NewChannel(ctx, "example", &medialive.ChannelArgs{
 * 			Name:         pulumi.String("example-channel"),
 * 			ChannelClass: pulumi.String("STANDARD"),
 * 			RoleArn:      pulumi.Any(exampleAwsIamRole.Arn),
 * 			InputSpecification: &medialive.ChannelInputSpecificationArgs{
 * 				Codec:           pulumi.String("AVC"),
 * 				InputResolution: pulumi.String("HD"),
 * 				MaximumBitrate:  pulumi.String("MAX_20_MBPS"),
 * 			},
 * 			InputAttachments: medialive.ChannelInputAttachmentArray{
 * 				&medialive.ChannelInputAttachmentArgs{
 * 					InputAttachmentName: pulumi.String("example-input"),
 * 					InputId:             pulumi.Any(exampleAwsMedialiveInput.Id),
 * 				},
 * 			},
 * 			Destinations: medialive.ChannelDestinationArray{
 * 				&medialive.ChannelDestinationArgs{
 * 					Id: pulumi.String("destination"),
 * 					Settings: medialive.ChannelDestinationSettingArray{
 * 						&medialive.ChannelDestinationSettingArgs{
 * 							Url: pulumi.Sprintf("s3://%v/test1", main.Id),
 * 						},
 * 						&medialive.ChannelDestinationSettingArgs{
 * 							Url: pulumi.Sprintf("s3://%v/test2", main2.Id),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			EncoderSettings: &medialive.ChannelEncoderSettingsArgs{
 * 				TimecodeConfig: &medialive.ChannelEncoderSettingsTimecodeConfigArgs{
 * 					Source: pulumi.String("EMBEDDED"),
 * 				},
 * 				AudioDescriptions: medialive.ChannelEncoderSettingsAudioDescriptionArray{
 * 					&medialive.ChannelEncoderSettingsAudioDescriptionArgs{
 * 						AudioSelectorName: pulumi.String("example audio selector"),
 * 						Name:              pulumi.String("audio-selector"),
 * 					},
 * 				},
 * 				VideoDescriptions: medialive.ChannelEncoderSettingsVideoDescriptionArray{
 * 					&medialive.ChannelEncoderSettingsVideoDescriptionArgs{
 * 						Name: pulumi.String("example-video"),
 * 					},
 * 				},
 * 				OutputGroups: medialive.ChannelEncoderSettingsOutputGroupArray{
 * 					&medialive.ChannelEncoderSettingsOutputGroupArgs{
 * 						OutputGroupSettings: &medialive.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs{
 * 							ArchiveGroupSettings: medialive.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArray{
 * 								&medialive.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs{
 * 									Destination: &medialive.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs{
 * 										DestinationRefId: pulumi.String("destination"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						Outputs: medialive.ChannelEncoderSettingsOutputGroupOutputTypeArray{
 * 							&medialive.ChannelEncoderSettingsOutputGroupOutputTypeArgs{
 * 								OutputName:           pulumi.String("example-name"),
 * 								VideoDescriptionName: pulumi.String("example-video"),
 * 								AudioDescriptionNames: pulumi.StringArray{
 * 									pulumi.String("audio-selector"),
 * 								},
 * 								OutputSettings: &medialive.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs{
 * 									ArchiveOutputSettings: &medialive.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs{
 * 										NameModifier: pulumi.String("_1"),
 * 										Extension:    pulumi.String("m2ts"),
 * 										ContainerSettings: &medialive.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs{
 * 											M2tsSettings: &medialive.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs{
 * 												AudioBufferModel: pulumi.String("ATSC"),
 * 												BufferModel:      pulumi.String("MULTIPLEX"),
 * 												RateMode:         pulumi.String("CBR"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.Channel;
 * import com.pulumi.aws.medialive.ChannelArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelDestinationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Channel("example", ChannelArgs.builder()
 *             .name("example-channel")
 *             .channelClass("STANDARD")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .inputSpecification(ChannelInputSpecificationArgs.builder()
 *                 .codec("AVC")
 *                 .inputResolution("HD")
 *                 .maximumBitrate("MAX_20_MBPS")
 *                 .build())
 *             .inputAttachments(ChannelInputAttachmentArgs.builder()
 *                 .inputAttachmentName("example-input")
 *                 .inputId(exampleAwsMedialiveInput.id())
 *                 .build())
 *             .destinations(ChannelDestinationArgs.builder()
 *                 .id("destination")
 *                 .settings(
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test1", main.id()))
 *                         .build(),
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test2", main2.id()))
 *                         .build())
 *                 .build())
 *             .encoderSettings(ChannelEncoderSettingsArgs.builder()
 *                 .timecodeConfig(ChannelEncoderSettingsTimecodeConfigArgs.builder()
 *                     .source("EMBEDDED")
 *                     .build())
 *                 .audioDescriptions(ChannelEncoderSettingsAudioDescriptionArgs.builder()
 *                     .audioSelectorName("example audio selector")
 *                     .name("audio-selector")
 *                     .build())
 *                 .videoDescriptions(ChannelEncoderSettingsVideoDescriptionArgs.builder()
 *                     .name("example-video")
 *                     .build())
 *                 .outputGroups(ChannelEncoderSettingsOutputGroupArgs.builder()
 *                     .outputGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs.builder()
 *                         .archiveGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs.builder()
 *                             .destination(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs.builder()
 *                                 .destinationRefId("destination")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .outputs(ChannelEncoderSettingsOutputGroupOutputArgs.builder()
 *                         .outputName("example-name")
 *                         .videoDescriptionName("example-video")
 *                         .audioDescriptionNames("audio-selector")
 *                         .outputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs.builder()
 *                             .archiveOutputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs.builder()
 *                                 .nameModifier("_1")
 *                                 .extension("m2ts")
 *                                 .containerSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs.builder()
 *                                     .m2tsSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs.builder()
 *                                         .audioBufferModel("ATSC")
 *                                         .bufferModel("MULTIPLEX")
 *                                         .rateMode("CBR")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:medialive:Channel
 *     properties:
 *       name: example-channel
 *       channelClass: STANDARD
 *       roleArn: ${exampleAwsIamRole.arn}
 *       inputSpecification:
 *         codec: AVC
 *         inputResolution: HD
 *         maximumBitrate: MAX_20_MBPS
 *       inputAttachments:
 *         - inputAttachmentName: example-input
 *           inputId: ${exampleAwsMedialiveInput.id}
 *       destinations:
 *         - id: destination
 *           settings:
 *             - url: s3://${main.id}/test1
 *             - url: s3://${main2.id}/test2
 *       encoderSettings:
 *         timecodeConfig:
 *           source: EMBEDDED
 *         audioDescriptions:
 *           - audioSelectorName: example audio selector
 *             name: audio-selector
 *         videoDescriptions:
 *           - name: example-video
 *         outputGroups:
 *           - outputGroupSettings:
 *               archiveGroupSettings:
 *                 - destination:
 *                     destinationRefId: destination
 *             outputs:
 *               - outputName: example-name
 *                 videoDescriptionName: example-video
 *                 audioDescriptionNames:
 *                   - audio-selector
 *                 outputSettings:
 *                   archiveOutputSettings:
 *                     nameModifier: _1
 *                     extension: m2ts
 *                     containerSettings:
 *                       m2tsSettings:
 *                         audioBufferModel: ATSC
 *                         bufferModel: MULTIPLEX
 *                         rateMode: CBR
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaLive Channel using the `channel_id`. For example:
 * ```sh
 * $ pulumi import aws:medialive/channel:Channel example 1234567
 * ```
 * @property cdiInputSpecification Specification of CDI inputs for this channel. See CDI Input Specification for more details.
 * @property channelClass Concise argument description.
 * @property destinations Destinations for channel. See Destinations for more details.
 * @property encoderSettings Encoder settings. See Encoder Settings for more details.
 * @property inputAttachments Input attachments for the channel. See Input Attachments for more details.
 * @property inputSpecification Specification of network and file inputs for the channel.
 * @property logLevel The log level to write to Cloudwatch logs.
 * @property maintenance Maintenance settings for this channel. See Maintenance for more details.
 * @property name Name of the Channel.
 * The following arguments are optional:
 * @property roleArn Concise argument description.
 * @property startChannel Whether to start/stop channel. Default: `false`
 * @property tags A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpc Settings for the VPC outputs. See VPC for more details.
 */
public data class ChannelArgs(
    public val cdiInputSpecification: Output<ChannelCdiInputSpecificationArgs>? = null,
    public val channelClass: Output<String>? = null,
    public val destinations: Output<List<ChannelDestinationArgs>>? = null,
    public val encoderSettings: Output<ChannelEncoderSettingsArgs>? = null,
    public val inputAttachments: Output<List<ChannelInputAttachmentArgs>>? = null,
    public val inputSpecification: Output<ChannelInputSpecificationArgs>? = null,
    public val logLevel: Output<String>? = null,
    public val maintenance: Output<ChannelMaintenanceArgs>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val startChannel: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpc: Output<ChannelVpcArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.ChannelArgs> {
    override fun toJava(): com.pulumi.aws.medialive.ChannelArgs =
        com.pulumi.aws.medialive.ChannelArgs.builder()
            .cdiInputSpecification(
                cdiInputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .channelClass(channelClass?.applyValue({ args0 -> args0 }))
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encoderSettings(encoderSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputAttachments(
                inputAttachments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSpecification(
                inputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .maintenance(maintenance?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .startChannel(startChannel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpc(vpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var cdiInputSpecification: Output<ChannelCdiInputSpecificationArgs>? = null

    private var channelClass: Output<String>? = null

    private var destinations: Output<List<ChannelDestinationArgs>>? = null

    private var encoderSettings: Output<ChannelEncoderSettingsArgs>? = null

    private var inputAttachments: Output<List<ChannelInputAttachmentArgs>>? = null

    private var inputSpecification: Output<ChannelInputSpecificationArgs>? = null

    private var logLevel: Output<String>? = null

    private var maintenance: Output<ChannelMaintenanceArgs>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var startChannel: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpc: Output<ChannelVpcArgs>? = null

    /**
     * @param value Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("vslwyidusmmxjddy")
    public suspend fun cdiInputSpecification(`value`: Output<ChannelCdiInputSpecificationArgs>) {
        this.cdiInputSpecification = value
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("ydjkmdjysexwuvht")
    public suspend fun channelClass(`value`: Output<String>) {
        this.channelClass = value
    }

    /**
     * @param value Destinations for channel. See Destinations for more details.
     */
    @JvmName("tvsajcvknhlumqrc")
    public suspend fun destinations(`value`: Output<List<ChannelDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("paruqdovrtgcoocx")
    public suspend fun destinations(vararg values: Output<ChannelDestinationArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Destinations for channel. See Destinations for more details.
     */
    @JvmName("xnrseolmfwrxipvq")
    public suspend fun destinations(values: List<Output<ChannelDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("rdmfwrpxenebijhb")
    public suspend fun encoderSettings(`value`: Output<ChannelEncoderSettingsArgs>) {
        this.encoderSettings = value
    }

    /**
     * @param value Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("mgnkewhidgpnptrg")
    public suspend fun inputAttachments(`value`: Output<List<ChannelInputAttachmentArgs>>) {
        this.inputAttachments = value
    }

    @JvmName("ikjpoxhhoyhhnpkx")
    public suspend fun inputAttachments(vararg values: Output<ChannelInputAttachmentArgs>) {
        this.inputAttachments = Output.all(values.asList())
    }

    /**
     * @param values Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("lonbrnwwrranpnae")
    public suspend fun inputAttachments(values: List<Output<ChannelInputAttachmentArgs>>) {
        this.inputAttachments = Output.all(values)
    }

    /**
     * @param value Specification of network and file inputs for the channel.
     */
    @JvmName("aydderhwrrmmunyq")
    public suspend fun inputSpecification(`value`: Output<ChannelInputSpecificationArgs>) {
        this.inputSpecification = value
    }

    /**
     * @param value The log level to write to Cloudwatch logs.
     */
    @JvmName("lyenvuxjdvnsxrnn")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("cnovtjpbbwbnnopv")
    public suspend fun maintenance(`value`: Output<ChannelMaintenanceArgs>) {
        this.maintenance = value
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("orinkhirhqpxobxc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("faykbhxsqwlnxqpi")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Whether to start/stop channel. Default: `false`
     */
    @JvmName("cwgaarctbeodmoal")
    public suspend fun startChannel(`value`: Output<Boolean>) {
        this.startChannel = value
    }

    /**
     * @param value A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rlvydtuhsrallorj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("ircgjbfoqdrhojcg")
    public suspend fun vpc(`value`: Output<ChannelVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("lxluyrjrdnbmgwxs")
    public suspend fun cdiInputSpecification(`value`: ChannelCdiInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdiInputSpecification = mapped
    }

    /**
     * @param argument Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("jihdywgknpwvhmmg")
    public suspend fun cdiInputSpecification(argument: suspend ChannelCdiInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelCdiInputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cdiInputSpecification = mapped
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("imkefjplmbbmbgat")
    public suspend fun channelClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelClass = mapped
    }

    /**
     * @param value Destinations for channel. See Destinations for more details.
     */
    @JvmName("kawsmvvydmotywkl")
    public suspend fun destinations(`value`: List<ChannelDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("ipvyefnseojimmbq")
    public suspend fun destinations(argument: List<suspend ChannelDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("oylvuuubdrhylvan")
    public suspend fun destinations(vararg argument: suspend ChannelDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("sfgjbasbxkpmelbs")
    public suspend fun destinations(argument: suspend ChannelDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChannelDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Destinations for channel. See Destinations for more details.
     */
    @JvmName("ganvpwwboiieliya")
    public suspend fun destinations(vararg values: ChannelDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("qfjigpflumjftsuo")
    public suspend fun encoderSettings(`value`: ChannelEncoderSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoderSettings = mapped
    }

    /**
     * @param argument Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("dopvymoitexlwpqg")
    public suspend fun encoderSettings(argument: suspend ChannelEncoderSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encoderSettings = mapped
    }

    /**
     * @param value Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("sqrveqiipvoctpxm")
    public suspend fun inputAttachments(`value`: List<ChannelInputAttachmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("lwrqgygwmpissnws")
    public suspend fun inputAttachments(argument: List<suspend ChannelInputAttachmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("heugvrhxclbchvjn")
    public suspend fun inputAttachments(vararg argument: suspend ChannelInputAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("msuqtmlkmswipcgl")
    public suspend fun inputAttachments(argument: suspend ChannelInputAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChannelInputAttachmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param values Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("rcxclrwlqyvogxse")
    public suspend fun inputAttachments(vararg values: ChannelInputAttachmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputAttachments = mapped
    }

    /**
     * @param value Specification of network and file inputs for the channel.
     */
    @JvmName("hmwlevgxsdeaddpn")
    public suspend fun inputSpecification(`value`: ChannelInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSpecification = mapped
    }

    /**
     * @param argument Specification of network and file inputs for the channel.
     */
    @JvmName("echoxuuvluicfpfw")
    public suspend fun inputSpecification(argument: suspend ChannelInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelInputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputSpecification = mapped
    }

    /**
     * @param value The log level to write to Cloudwatch logs.
     */
    @JvmName("biboacyflrdjiaio")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("etnkqgmmdoqrnpta")
    public suspend fun maintenance(`value`: ChannelMaintenanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenance = mapped
    }

    /**
     * @param argument Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("fqhytaftedwopiwe")
    public suspend fun maintenance(argument: suspend ChannelMaintenanceArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelMaintenanceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenance = mapped
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("yrgjmpmwsfjuqkhv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("pinpngrsfsedvnsq")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Whether to start/stop channel. Default: `false`
     */
    @JvmName("wvhbyemtbnwinjip")
    public suspend fun startChannel(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startChannel = mapped
    }

    /**
     * @param value A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bcvwdhfjbfhgrwvu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qvqdpvrstwfobxeq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("xjyagwyavdatpqmf")
    public suspend fun vpc(`value`: ChannelVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("vdvfkxwisgwtoyns")
    public suspend fun vpc(argument: suspend ChannelVpcArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        cdiInputSpecification = cdiInputSpecification,
        channelClass = channelClass,
        destinations = destinations,
        encoderSettings = encoderSettings,
        inputAttachments = inputAttachments,
        inputSpecification = inputSpecification,
        logLevel = logLevel,
        maintenance = maintenance,
        name = name,
        roleArn = roleArn,
        startChannel = startChannel,
        tags = tags,
        vpc = vpc,
    )
}
