@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.InputArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.InputDestinationArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputDestinationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputInputDeviceArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputInputDeviceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputMediaConnectFlowArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputMediaConnectFlowArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputSourceArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputSourceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputVpcArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive Input.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.medialive.InputSecurityGroup("example", {
 *     whitelistRules: [{
 *         cidr: "10.0.0.8/32",
 *     }],
 *     tags: {
 *         ENVIRONMENT: "prod",
 *     },
 * });
 * const exampleInput = new aws.medialive.Input("example", {
 *     name: "example-input",
 *     inputSecurityGroups: [example&#46;id],
 *     type: "UDP_PUSH",
 *     tags: {
 *         ENVIRONMENT: "prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.medialive.InputSecurityGroup("example",
 *     whitelist_rules=[{
 *         "cidr": "10.0.0.8/32",
 *     }],
 *     tags={
 *         "ENVIRONMENT": "prod",
 *     })
 * example_input = aws.medialive.Input("example",
 *     name="example-input",
 *     input_security_groups=[example&#46;id],
 *     type="UDP_PUSH",
 *     tags={
 *         "ENVIRONMENT": "prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MediaLive.InputSecurityGroup("example", new()
 *     {
 *         WhitelistRules = new[]
 *         {
 *             new Aws.MediaLive.Inputs.InputSecurityGroupWhitelistRuleArgs
 *             {
 *                 Cidr = "10.0.0.8/32",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "ENVIRONMENT", "prod" },
 *         },
 *     });
 *     var exampleInput = new Aws.MediaLive.Input("example", new()
 *     {
 *         Name = "example-input",
 *         InputSecurityGroups = new[]
 *         {
 *             example.Id,
 *         },
 *         Type = "UDP_PUSH",
 *         Tags =
 *         {
 *             { "ENVIRONMENT", "prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := medialive.NewInputSecurityGroup(ctx, "example", &medialive.InputSecurityGroupArgs{
 * 			WhitelistRules: medialive.InputSecurityGroupWhitelistRuleArray{
 * 				&medialive.InputSecurityGroupWhitelistRuleArgs{
 * 					Cidr: pulumi.String("10.0.0.8/32"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ENVIRONMENT": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = medialive.NewInput(ctx, "example", &medialive.InputArgs{
 * 			Name: pulumi.String("example-input"),
 * 			InputSecurityGroups: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 			Type: pulumi.String("UDP_PUSH"),
 * 			Tags: pulumi.StringMap{
 * 				"ENVIRONMENT": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.InputSecurityGroup;
 * import com.pulumi.aws.medialive.InputSecurityGroupArgs;
 * import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs;
 * import com.pulumi.aws.medialive.Input;
 * import com.pulumi.aws.medialive.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InputSecurityGroup("example", InputSecurityGroupArgs.builder()
 *             .whitelistRules(InputSecurityGroupWhitelistRuleArgs.builder()
 *                 .cidr("10.0.0.8/32")
 *                 .build())
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *         var exampleInput = new Input("exampleInput", InputArgs.builder()
 *             .name("example-input")
 *             .inputSecurityGroups(example.id())
 *             .type("UDP_PUSH")
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:medialive:InputSecurityGroup
 *     properties:
 *       whitelistRules:
 *         - cidr: 10.0.0.8/32
 *       tags:
 *         ENVIRONMENT: prod
 *   exampleInput:
 *     type: aws:medialive:Input
 *     name: example
 *     properties:
 *       name: example-input
 *       inputSecurityGroups:
 *         - ${example.id}
 *       type: UDP_PUSH
 *       tags:
 *         ENVIRONMENT: prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaLive Input using the `id`. For example:
 * ```sh
 * $ pulumi import aws:medialive/input:Input example 12345678
 * ```
 * @property destinations Destination settings for PUSH type inputs. See Destinations for more details.
 * @property inputDevices Settings for the devices. See Input Devices for more details.
 * @property inputSecurityGroups List of input security groups.
 * @property mediaConnectFlows A list of the MediaConnect Flows. See Media Connect Flows for more details.
 * @property name Name of the input.
 * @property roleArn The ARN of the role this input assumes during and after creation.
 * @property sources The source URLs for a PULL-type input. See Sources for more details.
 * @property tags A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The different types of inputs that AWS Elemental MediaLive supports.
 * The following arguments are optional:
 * @property vpc Settings for a private VPC Input. See VPC for more details.
 */
public data class InputArgs(
    public val destinations: Output<List<InputDestinationArgs>>? = null,
    public val inputDevices: Output<List<InputInputDeviceArgs>>? = null,
    public val inputSecurityGroups: Output<List<String>>? = null,
    public val mediaConnectFlows: Output<List<InputMediaConnectFlowArgs>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sources: Output<List<InputSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpc: Output<InputVpcArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.InputArgs> {
    override fun toJava(): com.pulumi.aws.medialive.InputArgs =
        com.pulumi.aws.medialive.InputArgs.builder()
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputDevices(
                inputDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSecurityGroups(inputSecurityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mediaConnectFlows(
                mediaConnectFlows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpc(vpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InputArgs].
 */
@PulumiTagMarker
public class InputArgsBuilder internal constructor() {
    private var destinations: Output<List<InputDestinationArgs>>? = null

    private var inputDevices: Output<List<InputInputDeviceArgs>>? = null

    private var inputSecurityGroups: Output<List<String>>? = null

    private var mediaConnectFlows: Output<List<InputMediaConnectFlowArgs>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sources: Output<List<InputSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpc: Output<InputVpcArgs>? = null

    /**
     * @param value Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("fyrlodyywyfbitpa")
    public suspend fun destinations(`value`: Output<List<InputDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("cwilcyjpbnxjvtpf")
    public suspend fun destinations(vararg values: Output<InputDestinationArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("qghbhqantphsjasm")
    public suspend fun destinations(values: List<Output<InputDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Settings for the devices. See Input Devices for more details.
     */
    @JvmName("edruvactiaydfelr")
    public suspend fun inputDevices(`value`: Output<List<InputInputDeviceArgs>>) {
        this.inputDevices = value
    }

    @JvmName("movkwcakybjvihyf")
    public suspend fun inputDevices(vararg values: Output<InputInputDeviceArgs>) {
        this.inputDevices = Output.all(values.asList())
    }

    /**
     * @param values Settings for the devices. See Input Devices for more details.
     */
    @JvmName("riogiffgmustunpj")
    public suspend fun inputDevices(values: List<Output<InputInputDeviceArgs>>) {
        this.inputDevices = Output.all(values)
    }

    /**
     * @param value List of input security groups.
     */
    @JvmName("xhbybvywjdwpnoca")
    public suspend fun inputSecurityGroups(`value`: Output<List<String>>) {
        this.inputSecurityGroups = value
    }

    @JvmName("liobewmmknythjrx")
    public suspend fun inputSecurityGroups(vararg values: Output<String>) {
        this.inputSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of input security groups.
     */
    @JvmName("ysckkudmtulcbwea")
    public suspend fun inputSecurityGroups(values: List<Output<String>>) {
        this.inputSecurityGroups = Output.all(values)
    }

    /**
     * @param value A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("wsvduaxqtrrjlerg")
    public suspend fun mediaConnectFlows(`value`: Output<List<InputMediaConnectFlowArgs>>) {
        this.mediaConnectFlows = value
    }

    @JvmName("xenogrkxscnwrfac")
    public suspend fun mediaConnectFlows(vararg values: Output<InputMediaConnectFlowArgs>) {
        this.mediaConnectFlows = Output.all(values.asList())
    }

    /**
     * @param values A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("omvhsuqcsxdsppkx")
    public suspend fun mediaConnectFlows(values: List<Output<InputMediaConnectFlowArgs>>) {
        this.mediaConnectFlows = Output.all(values)
    }

    /**
     * @param value Name of the input.
     */
    @JvmName("bswcnuywgsbpjxbu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the role this input assumes during and after creation.
     */
    @JvmName("bbudrxvkecwwnwem")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("tiitdhbjwsmomjpu")
    public suspend fun sources(`value`: Output<List<InputSourceArgs>>) {
        this.sources = value
    }

    @JvmName("ifhlliqknmswvgih")
    public suspend fun sources(vararg values: Output<InputSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("kfiiwgcjryqyhjfn")
    public suspend fun sources(values: List<Output<InputSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbjerqpslhipjphs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The different types of inputs that AWS Elemental MediaLive supports.
     * The following arguments are optional:
     */
    @JvmName("ssfcqqjooecastyf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("utvplfwwbxooycka")
    public suspend fun vpc(`value`: Output<InputVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("wnyafvlblxsxcokg")
    public suspend fun destinations(`value`: List<InputDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("slvswgbuijvghwgq")
    public suspend fun destinations(argument: List<suspend InputDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("dfstgyhbtupykoua")
    public suspend fun destinations(vararg argument: suspend InputDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("larkcisrnypvsqii")
    public suspend fun destinations(argument: suspend InputDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("vhwcgsopirduugks")
    public suspend fun destinations(vararg values: InputDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Settings for the devices. See Input Devices for more details.
     */
    @JvmName("tvevxoqtkmvmgton")
    public suspend fun inputDevices(`value`: List<InputInputDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("cwekunmhntfbjvwp")
    public suspend fun inputDevices(argument: List<suspend InputInputDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputInputDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("kkeylsdvqbkjnvva")
    public suspend fun inputDevices(vararg argument: suspend InputInputDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputInputDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("rxuvfaxtunicmkwv")
    public suspend fun inputDevices(argument: suspend InputInputDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputInputDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param values Settings for the devices. See Input Devices for more details.
     */
    @JvmName("ophmapyxgbnunqll")
    public suspend fun inputDevices(vararg values: InputInputDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputDevices = mapped
    }

    /**
     * @param value List of input security groups.
     */
    @JvmName("utaqsvfrrskdfdrw")
    public suspend fun inputSecurityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSecurityGroups = mapped
    }

    /**
     * @param values List of input security groups.
     */
    @JvmName("vjmepvovxogqkfxq")
    public suspend fun inputSecurityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSecurityGroups = mapped
    }

    /**
     * @param value A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("fvhyjcurclissuml")
    public suspend fun mediaConnectFlows(`value`: List<InputMediaConnectFlowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("qjvuucarwvlirnpj")
    public suspend fun mediaConnectFlows(argument: List<suspend InputMediaConnectFlowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputMediaConnectFlowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("imniycbuevvrvwoj")
    public suspend fun mediaConnectFlows(vararg argument: suspend InputMediaConnectFlowArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputMediaConnectFlowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("jouxftgnirypqlql")
    public suspend fun mediaConnectFlows(argument: suspend InputMediaConnectFlowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputMediaConnectFlowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param values A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("mhoklggutrjxxtkj")
    public suspend fun mediaConnectFlows(vararg values: InputMediaConnectFlowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaConnectFlows = mapped
    }

    /**
     * @param value Name of the input.
     */
    @JvmName("rxxrehpolslhypep")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the role this input assumes during and after creation.
     */
    @JvmName("ikotxkgjvofpftph")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("wpomljhxxsigsgsx")
    public suspend fun sources(`value`: List<InputSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("iqnsxfpbylrngvlv")
    public suspend fun sources(argument: List<suspend InputSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { InputSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("crieiyyqkpxtsvci")
    public suspend fun sources(vararg argument: suspend InputSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { InputSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("yaortvtphsimhifp")
    public suspend fun sources(argument: suspend InputSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("oprlflduskyuytro")
    public suspend fun sources(vararg values: InputSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjsijhtijshthsyy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dqnnnflhdkhevdbr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The different types of inputs that AWS Elemental MediaLive supports.
     * The following arguments are optional:
     */
    @JvmName("qulchbkljanfnwcr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("tnhibpikbqlvhqav")
    public suspend fun vpc(`value`: InputVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("eukapouvvsqbchyr")
    public suspend fun vpc(argument: suspend InputVpcArgsBuilder.() -> Unit) {
        val toBeMapped = InputVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): InputArgs = InputArgs(
        destinations = destinations,
        inputDevices = inputDevices,
        inputSecurityGroups = inputSecurityGroups,
        mediaConnectFlows = mediaConnectFlows,
        name = name,
        roleArn = roleArn,
        sources = sources,
        tags = tags,
        type = type,
        vpc = vpc,
    )
}
