@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.InputSecurityGroupArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.InputSecurityGroupWhitelistRuleArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputSecurityGroupWhitelistRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive InputSecurityGroup.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.medialive.InputSecurityGroup("example", {
 *     whitelistRules: [{
 *         cidr: "10.0.0.8/32",
 *     }],
 *     tags: {
 *         ENVIRONMENT: "prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.medialive.InputSecurityGroup("example",
 *     whitelist_rules=[{
 *         "cidr": "10.0.0.8/32",
 *     }],
 *     tags={
 *         "ENVIRONMENT": "prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MediaLive.InputSecurityGroup("example", new()
 *     {
 *         WhitelistRules = new[]
 *         {
 *             new Aws.MediaLive.Inputs.InputSecurityGroupWhitelistRuleArgs
 *             {
 *                 Cidr = "10.0.0.8/32",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "ENVIRONMENT", "prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := medialive.NewInputSecurityGroup(ctx, "example", &medialive.InputSecurityGroupArgs{
 * 			WhitelistRules: medialive.InputSecurityGroupWhitelistRuleArray{
 * 				&medialive.InputSecurityGroupWhitelistRuleArgs{
 * 					Cidr: pulumi.String("10.0.0.8/32"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ENVIRONMENT": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.InputSecurityGroup;
 * import com.pulumi.aws.medialive.InputSecurityGroupArgs;
 * import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InputSecurityGroup("example", InputSecurityGroupArgs.builder()
 *             .whitelistRules(InputSecurityGroupWhitelistRuleArgs.builder()
 *                 .cidr("10.0.0.8/32")
 *                 .build())
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:medialive:InputSecurityGroup
 *     properties:
 *       whitelistRules:
 *         - cidr: 10.0.0.8/32
 *       tags:
 *         ENVIRONMENT: prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaLive InputSecurityGroup using the `id`. For example:
 * ```sh
 * $ pulumi import aws:medialive/inputSecurityGroup:InputSecurityGroup example 123456
 * ```
 * @property tags A map of tags to assign to the InputSecurityGroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property whitelistRules Whitelist rules. See Whitelist Rules for more details.
 * The following arguments are optional:
 */
public data class InputSecurityGroupArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val whitelistRules: Output<List<InputSecurityGroupWhitelistRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.InputSecurityGroupArgs> {
    override fun toJava(): com.pulumi.aws.medialive.InputSecurityGroupArgs =
        com.pulumi.aws.medialive.InputSecurityGroupArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .whitelistRules(
                whitelistRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InputSecurityGroupArgs].
 */
@PulumiTagMarker
public class InputSecurityGroupArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var whitelistRules: Output<List<InputSecurityGroupWhitelistRuleArgs>>? = null

    /**
     * @param value A map of tags to assign to the InputSecurityGroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("driywtcdtrtoldik")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("btarckpyfxgfjjgj")
    public suspend fun whitelistRules(`value`: Output<List<InputSecurityGroupWhitelistRuleArgs>>) {
        this.whitelistRules = value
    }

    @JvmName("faxpnbskomojuwnm")
    public suspend fun whitelistRules(vararg values: Output<InputSecurityGroupWhitelistRuleArgs>) {
        this.whitelistRules = Output.all(values.asList())
    }

    /**
     * @param values Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("swfgxjmblqavslrx")
    public suspend fun whitelistRules(values: List<Output<InputSecurityGroupWhitelistRuleArgs>>) {
        this.whitelistRules = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the InputSecurityGroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ixevwnpcxbrcrqwa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the InputSecurityGroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ddfbijfhorcqirdw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("ekkjyoquqkhgduae")
    public suspend fun whitelistRules(`value`: List<InputSecurityGroupWhitelistRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitelistRules = mapped
    }

    /**
     * @param argument Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("wqdcsidxqncpasuy")
    public suspend fun whitelistRules(argument: List<suspend InputSecurityGroupWhitelistRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputSecurityGroupWhitelistRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.whitelistRules = mapped
    }

    /**
     * @param argument Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("qcdelsjmjfyuosbj")
    public suspend fun whitelistRules(vararg argument: suspend InputSecurityGroupWhitelistRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputSecurityGroupWhitelistRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.whitelistRules = mapped
    }

    /**
     * @param argument Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("xhwgoqkliytxoqnd")
    public suspend fun whitelistRules(argument: suspend InputSecurityGroupWhitelistRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InputSecurityGroupWhitelistRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.whitelistRules = mapped
    }

    /**
     * @param values Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    @JvmName("jwtbwvggfrtdtglc")
    public suspend fun whitelistRules(vararg values: InputSecurityGroupWhitelistRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.whitelistRules = mapped
    }

    internal fun build(): InputSecurityGroupArgs = InputSecurityGroupArgs(
        tags = tags,
        whitelistRules = whitelistRules,
    )
}
