@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.MedialiveFunctions.getInputPlain
import com.pulumi.aws.medialive.kotlin.inputs.GetInputPlainArgs
import com.pulumi.aws.medialive.kotlin.inputs.GetInputPlainArgsBuilder
import com.pulumi.aws.medialive.kotlin.outputs.GetInputResult
import com.pulumi.aws.medialive.kotlin.outputs.GetInputResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object MedialiveFunctions {
    /**
     * Data source for managing an AWS Elemental MediaLive Input.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.medialive.getInput({
     *     id: exampleAwsMedialiveInput.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.medialive.get_input(id=example_aws_medialive_input["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.MediaLive.GetInput.Invoke(new()
     *     {
     *         Id = exampleAwsMedialiveInput.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := medialive.LookupInput(ctx, &medialive.LookupInputArgs{
     * 			Id: exampleAwsMedialiveInput.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.medialive.MedialiveFunctions;
     * import com.pulumi.aws.medialive.inputs.GetInputArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MedialiveFunctions.getInput(GetInputArgs.builder()
     *             .id(exampleAwsMedialiveInput.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:medialive:getInput
     *       Arguments:
     *         id: ${exampleAwsMedialiveInput.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInput.
     * @return A collection of values returned by getInput.
     */
    public suspend fun getInput(argument: GetInputPlainArgs): GetInputResult =
        toKotlin(getInputPlain(argument.toJava()).await())

    /**
     * @see [getInput].
     * @param id The ID of the Input.
     * @return A collection of values returned by getInput.
     */
    public suspend fun getInput(id: String): GetInputResult {
        val argument = GetInputPlainArgs(
            id = id,
        )
        return toKotlin(getInputPlain(argument.toJava()).await())
    }

    /**
     * @see [getInput].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;medialive&#46;kotlin&#46;inputs&#46;GetInputPlainArgs].
     * @return A collection of values returned by getInput.
     */
    public suspend fun getInput(argument: suspend GetInputPlainArgsBuilder.() -> Unit): GetInputResult {
        val builder = GetInputPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getInputPlain(builtArgument.toJava()).await())
    }
}
