@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.MultiplexMultiplexSettings
import com.pulumi.aws.medialive.kotlin.outputs.MultiplexMultiplexSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Multiplex].
 */
@PulumiTagMarker
public class MultiplexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultiplexArgs = MultiplexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultiplexArgsBuilder.() -> Unit) {
        val builder = MultiplexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Multiplex {
        val builtJavaResource = com.pulumi.aws.medialive.Multiplex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Multiplex(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive Multiplex.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 * });
 * const example = new aws.medialive.Multiplex("example", {
 *     name: "example-multiplex-changed",
 *     availabilityZones: [
 *         available.then(available => available.names?.[0]),
 *         available.then(available => available.names?.[1]),
 *     ],
 *     multiplexSettings: {
 *         transportStreamBitrate: 1000000,
 *         transportStreamId: 1,
 *         transportStreamReservedBitrate: 1,
 *         maximumVideoBufferDelayMilliseconds: 1000,
 *     },
 *     startMultiplex: true,
 *     tags: {
 *         tag1: "value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available")
 * example = aws.medialive.Multiplex("example",
 *     name="example-multiplex-changed",
 *     availability_zones=[
 *         available.names[0],
 *         available.names[1],
 *     ],
 *     multiplex_settings={
 *         "transport_stream_bitrate": 1000000,
 *         "transport_stream_id": 1,
 *         "transport_stream_reserved_bitrate": 1,
 *         "maximum_video_buffer_delay_milliseconds": 1000,
 *     },
 *     start_multiplex=True,
 *     tags={
 *         "tag1": "value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *     });
 *     var example = new Aws.MediaLive.Multiplex("example", new()
 *     {
 *         Name = "example-multiplex-changed",
 *         AvailabilityZones = new[]
 *         {
 *             available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *             available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[1]),
 *         },
 *         MultiplexSettings = new Aws.MediaLive.Inputs.MultiplexMultiplexSettingsArgs
 *         {
 *             TransportStreamBitrate = 1000000,
 *             TransportStreamId = 1,
 *             TransportStreamReservedBitrate = 1,
 *             MaximumVideoBufferDelayMilliseconds = 1000,
 *         },
 *         StartMultiplex = true,
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = medialive.NewMultiplex(ctx, "example", &medialive.MultiplexArgs{
 * 			Name: pulumi.String("example-multiplex-changed"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String(available.Names[0]),
 * 				pulumi.String(available.Names[1]),
 * 			},
 * 			MultiplexSettings: &medialive.MultiplexMultiplexSettingsArgs{
 * 				TransportStreamBitrate:              pulumi.Int(1000000),
 * 				TransportStreamId:                   pulumi.Int(1),
 * 				TransportStreamReservedBitrate:      pulumi.Int(1),
 * 				MaximumVideoBufferDelayMilliseconds: pulumi.Int(1000),
 * 			},
 * 			StartMultiplex: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var example = new Multiplex("example", MultiplexArgs.builder()
 *             .name("example-multiplex-changed")
 *             .availabilityZones(
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of("tag1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:medialive:Multiplex
 *     properties:
 *       name: example-multiplex-changed
 *       availabilityZones:
 *         - ${available.names[0]}
 *         - ${available.names[1]}
 *       multiplexSettings:
 *         transportStreamBitrate: 1e+06
 *         transportStreamId: 1
 *         transportStreamReservedBitrate: 1
 *         maximumVideoBufferDelayMilliseconds: 1000
 *       startMultiplex: true
 *       tags:
 *         tag1: value1
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaLive Multiplex using the `id`. For example:
 * ```sh
 * $ pulumi import aws:medialive/multiplex:Multiplex example 12345678
 * ```
 */
public class Multiplex internal constructor(
    override val javaResource: com.pulumi.aws.medialive.Multiplex,
) : KotlinCustomResource(javaResource, MultiplexMapper) {
    /**
     * ARN of the Multiplex.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones. You must specify exactly two.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Multiplex settings. See Multiplex Settings for more details.
     */
    public val multiplexSettings: Output<MultiplexMultiplexSettings>?
        get() = javaResource.multiplexSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * name of Multiplex.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether to start the Multiplex. Defaults to `false`.
     */
    public val startMultiplex: Output<Boolean>?
        get() = javaResource.startMultiplex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MultiplexMapper : ResourceMapper<Multiplex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.Multiplex::class == javaResource::class

    override fun map(javaResource: Resource): Multiplex = Multiplex(
        javaResource as
            com.pulumi.aws.medialive.Multiplex,
    )
}

/**
 * @see [Multiplex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Multiplex].
 */
public suspend fun multiplex(name: String, block: suspend MultiplexResourceBuilder.() -> Unit): Multiplex {
    val builder = MultiplexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Multiplex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multiplex(name: String): Multiplex {
    val builder = MultiplexResourceBuilder()
    builder.name(name)
    return builder.build()
}
