@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.MultiplexArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.MultiplexMultiplexSettingsArgs
import com.pulumi.aws.medialive.kotlin.inputs.MultiplexMultiplexSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive Multiplex.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 * });
 * const example = new aws.medialive.Multiplex("example", {
 *     name: "example-multiplex-changed",
 *     availabilityZones: [
 *         available.then(available => available.names?.[0]),
 *         available.then(available => available.names?.[1]),
 *     ],
 *     multiplexSettings: {
 *         transportStreamBitrate: 1000000,
 *         transportStreamId: 1,
 *         transportStreamReservedBitrate: 1,
 *         maximumVideoBufferDelayMilliseconds: 1000,
 *     },
 *     startMultiplex: true,
 *     tags: {
 *         tag1: "value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available")
 * example = aws.medialive.Multiplex("example",
 *     name="example-multiplex-changed",
 *     availability_zones=[
 *         available.names[0],
 *         available.names[1],
 *     ],
 *     multiplex_settings={
 *         "transport_stream_bitrate": 1000000,
 *         "transport_stream_id": 1,
 *         "transport_stream_reserved_bitrate": 1,
 *         "maximum_video_buffer_delay_milliseconds": 1000,
 *     },
 *     start_multiplex=True,
 *     tags={
 *         "tag1": "value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *     });
 *     var example = new Aws.MediaLive.Multiplex("example", new()
 *     {
 *         Name = "example-multiplex-changed",
 *         AvailabilityZones = new[]
 *         {
 *             available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *             available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[1]),
 *         },
 *         MultiplexSettings = new Aws.MediaLive.Inputs.MultiplexMultiplexSettingsArgs
 *         {
 *             TransportStreamBitrate = 1000000,
 *             TransportStreamId = 1,
 *             TransportStreamReservedBitrate = 1,
 *             MaximumVideoBufferDelayMilliseconds = 1000,
 *         },
 *         StartMultiplex = true,
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/medialive"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = medialive.NewMultiplex(ctx, "example", &medialive.MultiplexArgs{
 * 			Name: pulumi.String("example-multiplex-changed"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String(available.Names[0]),
 * 				pulumi.String(available.Names[1]),
 * 			},
 * 			MultiplexSettings: &medialive.MultiplexMultiplexSettingsArgs{
 * 				TransportStreamBitrate:              pulumi.Int(1000000),
 * 				TransportStreamId:                   pulumi.Int(1),
 * 				TransportStreamReservedBitrate:      pulumi.Int(1),
 * 				MaximumVideoBufferDelayMilliseconds: pulumi.Int(1000),
 * 			},
 * 			StartMultiplex: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var example = new Multiplex("example", MultiplexArgs.builder()
 *             .name("example-multiplex-changed")
 *             .availabilityZones(
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of("tag1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:medialive:Multiplex
 *     properties:
 *       name: example-multiplex-changed
 *       availabilityZones:
 *         - ${available.names[0]}
 *         - ${available.names[1]}
 *       multiplexSettings:
 *         transportStreamBitrate: 1e+06
 *         transportStreamId: 1
 *         transportStreamReservedBitrate: 1
 *         maximumVideoBufferDelayMilliseconds: 1000
 *       startMultiplex: true
 *       tags:
 *         tag1: value1
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaLive Multiplex using the `id`. For example:
 * ```sh
 * $ pulumi import aws:medialive/multiplex:Multiplex example 12345678
 * ```
 * @property availabilityZones A list of availability zones. You must specify exactly two.
 * @property multiplexSettings Multiplex settings. See Multiplex Settings for more details.
 * @property name name of Multiplex.
 * The following arguments are optional:
 * @property startMultiplex Whether to start the Multiplex. Defaults to `false`.
 * @property tags A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MultiplexArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val multiplexSettings: Output<MultiplexMultiplexSettingsArgs>? = null,
    public val name: Output<String>? = null,
    public val startMultiplex: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.MultiplexArgs> {
    override fun toJava(): com.pulumi.aws.medialive.MultiplexArgs =
        com.pulumi.aws.medialive.MultiplexArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .multiplexSettings(multiplexSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .startMultiplex(startMultiplex?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MultiplexArgs].
 */
@PulumiTagMarker
public class MultiplexArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var multiplexSettings: Output<MultiplexMultiplexSettingsArgs>? = null

    private var name: Output<String>? = null

    private var startMultiplex: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of availability zones. You must specify exactly two.
     */
    @JvmName("pclawaeoqctheqyr")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("quvmhynjtqkogcfs")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones. You must specify exactly two.
     */
    @JvmName("jmkbbsxiowylxlsj")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Multiplex settings. See Multiplex Settings for more details.
     */
    @JvmName("exgssnmvfmucxoqi")
    public suspend fun multiplexSettings(`value`: Output<MultiplexMultiplexSettingsArgs>) {
        this.multiplexSettings = value
    }

    /**
     * @param value name of Multiplex.
     * The following arguments are optional:
     */
    @JvmName("crnkwcrndikwphjw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to start the Multiplex. Defaults to `false`.
     */
    @JvmName("ubisrswvfqfiiqhv")
    public suspend fun startMultiplex(`value`: Output<Boolean>) {
        this.startMultiplex = value
    }

    /**
     * @param value A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ikmmkmylkbtpgoms")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones. You must specify exactly two.
     */
    @JvmName("piukbxupfhtgqkvq")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values A list of availability zones. You must specify exactly two.
     */
    @JvmName("vnwivsxgmpkhvxwr")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Multiplex settings. See Multiplex Settings for more details.
     */
    @JvmName("qjkweomxtsmbcfag")
    public suspend fun multiplexSettings(`value`: MultiplexMultiplexSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexSettings = mapped
    }

    /**
     * @param argument Multiplex settings. See Multiplex Settings for more details.
     */
    @JvmName("eclviqngvtliadhi")
    public suspend fun multiplexSettings(argument: suspend MultiplexMultiplexSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiplexMultiplexSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.multiplexSettings = mapped
    }

    /**
     * @param value name of Multiplex.
     * The following arguments are optional:
     */
    @JvmName("uuhkqyodtuuskcmy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to start the Multiplex. Defaults to `false`.
     */
    @JvmName("ywjrjeoexbgudmvd")
    public suspend fun startMultiplex(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startMultiplex = mapped
    }

    /**
     * @param value A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("myderovsqfshycaw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uresyncsmwsuywnu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MultiplexArgs = MultiplexArgs(
        availabilityZones = availabilityZones,
        multiplexSettings = multiplexSettings,
        name = name,
        startMultiplex = startMultiplex,
        tags = tags,
    )
}
