@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelCdiInputSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resolution Maximum CDI input resolution.
 */
public data class ChannelCdiInputSpecificationArgs(
    public val resolution: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelCdiInputSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelCdiInputSpecificationArgs =
        com.pulumi.aws.medialive.inputs.ChannelCdiInputSpecificationArgs.builder()
            .resolution(resolution.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelCdiInputSpecificationArgs].
 */
@PulumiTagMarker
public class ChannelCdiInputSpecificationArgsBuilder internal constructor() {
    private var resolution: Output<String>? = null

    /**
     * @param value Maximum CDI input resolution.
     */
    @JvmName("otxvakxrktdnahte")
    public suspend fun resolution(`value`: Output<String>) {
        this.resolution = value
    }

    /**
     * @param value Maximum CDI input resolution.
     */
    @JvmName("ewgqwesrqemeayvw")
    public suspend fun resolution(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    internal fun build(): ChannelCdiInputSpecificationArgs = ChannelCdiInputSpecificationArgs(
        resolution = resolution ?: throw PulumiNullFieldException("resolution"),
    )
}
