@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelDestinationMediaPackageSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channelId ID of the channel in MediaPackage that is the destination for this output group.
 */
public data class ChannelDestinationMediaPackageSettingArgs(
    public val channelId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelDestinationMediaPackageSettingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelDestinationMediaPackageSettingArgs =
        com.pulumi.aws.medialive.inputs.ChannelDestinationMediaPackageSettingArgs.builder()
            .channelId(channelId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelDestinationMediaPackageSettingArgs].
 */
@PulumiTagMarker
public class ChannelDestinationMediaPackageSettingArgsBuilder internal constructor() {
    private var channelId: Output<String>? = null

    /**
     * @param value ID of the channel in MediaPackage that is the destination for this output group.
     */
    @JvmName("wrrepgjyvlgotjmw")
    public suspend fun channelId(`value`: Output<String>) {
        this.channelId = value
    }

    /**
     * @param value ID of the channel in MediaPackage that is the destination for this output group.
     */
    @JvmName("vwjcqqsjjvqxufbl")
    public suspend fun channelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelId = mapped
    }

    internal fun build(): ChannelDestinationMediaPackageSettingArgs =
        ChannelDestinationMediaPackageSettingArgs(
            channelId = channelId ?: throw PulumiNullFieldException("channelId"),
        )
}
