@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelDestinationSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordParam Key used to extract the password from EC2 Parameter store.
 * @property streamName Stream name RTMP destinations (URLs of type rtmp://)
 * @property url A URL specifying a destination.
 * @property username Username for destination.
 */
public data class ChannelDestinationSettingArgs(
    public val passwordParam: Output<String>? = null,
    public val streamName: Output<String>? = null,
    public val url: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelDestinationSettingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelDestinationSettingArgs =
        com.pulumi.aws.medialive.inputs.ChannelDestinationSettingArgs.builder()
            .passwordParam(passwordParam?.applyValue({ args0 -> args0 }))
            .streamName(streamName?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelDestinationSettingArgs].
 */
@PulumiTagMarker
public class ChannelDestinationSettingArgsBuilder internal constructor() {
    private var passwordParam: Output<String>? = null

    private var streamName: Output<String>? = null

    private var url: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("rcclnfbktkcukyun")
    public suspend fun passwordParam(`value`: Output<String>) {
        this.passwordParam = value
    }

    /**
     * @param value Stream name RTMP destinations (URLs of type rtmp://)
     */
    @JvmName("tprgakcuuwullpjv")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value A URL specifying a destination.
     */
    @JvmName("qosyyfmianbrlxqb")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Username for destination.
     */
    @JvmName("etyngskaeeuxrahv")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("wcjgyxprbslhqsal")
    public suspend fun passwordParam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordParam = mapped
    }

    /**
     * @param value Stream name RTMP destinations (URLs of type rtmp://)
     */
    @JvmName("qvquwjwjokvicpfd")
    public suspend fun streamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    /**
     * @param value A URL specifying a destination.
     */
    @JvmName("oqyfytaafxotedqr")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Username for destination.
     */
    @JvmName("fnkemqchkrdolbaa")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ChannelDestinationSettingArgs = ChannelDestinationSettingArgs(
        passwordParam = passwordParam,
        streamName = streamName,
        url = url,
        username = username,
    )
}
