@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audioDescriptions Audio descriptions for the channel. See Audio Descriptions for more details.
 * @property availBlanking Settings for ad avail blanking. See Avail Blanking for more details.
 * @property captionDescriptions Caption Descriptions. See Caption Descriptions for more details.
 * @property globalConfiguration Configuration settings that apply to the event as a whole. See Global Configuration for more details.
 * @property motionGraphicsConfiguration Settings for motion graphics. See Motion Graphics Configuration for more details.
 * @property nielsenConfiguration Nielsen configuration settings. See Nielsen Configuration for more details.
 * @property outputGroups Output groups for the channel. See Output Groups for more details.
 * @property timecodeConfig Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
 * @property videoDescriptions Video Descriptions. See Video Descriptions for more details.
 */
public data class ChannelEncoderSettingsArgs(
    public val audioDescriptions: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>? = null,
    public val availBlanking: Output<ChannelEncoderSettingsAvailBlankingArgs>? = null,
    public val captionDescriptions: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>? =
        null,
    public val globalConfiguration: Output<ChannelEncoderSettingsGlobalConfigurationArgs>? = null,
    public val motionGraphicsConfiguration: Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>? = null,
    public val nielsenConfiguration: Output<ChannelEncoderSettingsNielsenConfigurationArgs>? = null,
    public val outputGroups: Output<List<ChannelEncoderSettingsOutputGroupArgs>>,
    public val timecodeConfig: Output<ChannelEncoderSettingsTimecodeConfigArgs>,
    public val videoDescriptions: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs.builder()
            .audioDescriptions(
                audioDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .availBlanking(availBlanking?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captionDescriptions(
                captionDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .globalConfiguration(
                globalConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .motionGraphicsConfiguration(
                motionGraphicsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nielsenConfiguration(
                nielsenConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputGroups(
                outputGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timecodeConfig(timecodeConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoDescriptions(
                videoDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsArgsBuilder internal constructor() {
    private var audioDescriptions: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>? = null

    private var availBlanking: Output<ChannelEncoderSettingsAvailBlankingArgs>? = null

    private var captionDescriptions: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>? =
        null

    private var globalConfiguration: Output<ChannelEncoderSettingsGlobalConfigurationArgs>? = null

    private var motionGraphicsConfiguration:
        Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>? = null

    private var nielsenConfiguration: Output<ChannelEncoderSettingsNielsenConfigurationArgs>? = null

    private var outputGroups: Output<List<ChannelEncoderSettingsOutputGroupArgs>>? = null

    private var timecodeConfig: Output<ChannelEncoderSettingsTimecodeConfigArgs>? = null

    private var videoDescriptions: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>? = null

    /**
     * @param value Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("kmrlvsxuflemcodx")
    public suspend fun audioDescriptions(`value`: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>) {
        this.audioDescriptions = value
    }

    @JvmName("xrshqltvtpoinfsh")
    public suspend fun audioDescriptions(vararg values: Output<ChannelEncoderSettingsAudioDescriptionArgs>) {
        this.audioDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("eqvntkygysepgcsu")
    public suspend fun audioDescriptions(values: List<Output<ChannelEncoderSettingsAudioDescriptionArgs>>) {
        this.audioDescriptions = Output.all(values)
    }

    /**
     * @param value Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("tfpaspmrrsypbvhc")
    public suspend fun availBlanking(`value`: Output<ChannelEncoderSettingsAvailBlankingArgs>) {
        this.availBlanking = value
    }

    /**
     * @param value Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("hjrtodatfpytllpm")
    public suspend fun captionDescriptions(`value`: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>) {
        this.captionDescriptions = value
    }

    @JvmName("yknxcuqbshijfufg")
    public suspend fun captionDescriptions(vararg values: Output<ChannelEncoderSettingsCaptionDescriptionArgs>) {
        this.captionDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("yaurpmjrofcsjbpe")
    public suspend fun captionDescriptions(values: List<Output<ChannelEncoderSettingsCaptionDescriptionArgs>>) {
        this.captionDescriptions = Output.all(values)
    }

    /**
     * @param value Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("rpbrklbkjclfeyul")
    public suspend fun globalConfiguration(`value`: Output<ChannelEncoderSettingsGlobalConfigurationArgs>) {
        this.globalConfiguration = value
    }

    /**
     * @param value Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("kllduiobhdyugcnj")
    public suspend fun motionGraphicsConfiguration(`value`: Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>) {
        this.motionGraphicsConfiguration = value
    }

    /**
     * @param value Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("evxvwiiwkmmwuuyr")
    public suspend fun nielsenConfiguration(`value`: Output<ChannelEncoderSettingsNielsenConfigurationArgs>) {
        this.nielsenConfiguration = value
    }

    /**
     * @param value Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("vyqyrkwcffmdowlq")
    public suspend fun outputGroups(`value`: Output<List<ChannelEncoderSettingsOutputGroupArgs>>) {
        this.outputGroups = value
    }

    @JvmName("ercytfmjytxfdgvw")
    public suspend fun outputGroups(vararg values: Output<ChannelEncoderSettingsOutputGroupArgs>) {
        this.outputGroups = Output.all(values.asList())
    }

    /**
     * @param values Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("gewrfftsoxochqpl")
    public suspend fun outputGroups(values: List<Output<ChannelEncoderSettingsOutputGroupArgs>>) {
        this.outputGroups = Output.all(values)
    }

    /**
     * @param value Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("uqssuaurankqdigf")
    public suspend fun timecodeConfig(`value`: Output<ChannelEncoderSettingsTimecodeConfigArgs>) {
        this.timecodeConfig = value
    }

    /**
     * @param value Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("eiajwbhglvofcpwf")
    public suspend fun videoDescriptions(`value`: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>) {
        this.videoDescriptions = value
    }

    @JvmName("wenlulhamfpkhqyg")
    public suspend fun videoDescriptions(vararg values: Output<ChannelEncoderSettingsVideoDescriptionArgs>) {
        this.videoDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("qrdkgcyyxnmuiwny")
    public suspend fun videoDescriptions(values: List<Output<ChannelEncoderSettingsVideoDescriptionArgs>>) {
        this.videoDescriptions = Output.all(values)
    }

    /**
     * @param value Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("bdkwwhsqrrcceldr")
    public suspend fun audioDescriptions(`value`: List<ChannelEncoderSettingsAudioDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("rvcjxvqayftvvjdg")
    public suspend fun audioDescriptions(argument: List<suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("biguwyloskcbxqvf")
    public suspend fun audioDescriptions(vararg argument: suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("eeloqlfsknqgbbvf")
    public suspend fun audioDescriptions(argument: suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param values Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("gdikbbsatoyrbmbg")
    public suspend fun audioDescriptions(vararg values: ChannelEncoderSettingsAudioDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioDescriptions = mapped
    }

    /**
     * @param value Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("rnqadielioihfgpy")
    public suspend fun availBlanking(`value`: ChannelEncoderSettingsAvailBlankingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availBlanking = mapped
    }

    /**
     * @param argument Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("cpememptxajwtwkn")
    public suspend fun availBlanking(argument: suspend ChannelEncoderSettingsAvailBlankingArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsAvailBlankingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.availBlanking = mapped
    }

    /**
     * @param value Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("irftdjlvvervhqdy")
    public suspend fun captionDescriptions(`value`: List<ChannelEncoderSettingsCaptionDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("rfxyusatbanuitnc")
    public suspend fun captionDescriptions(argument: List<suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("mljpbwjonammfkjy")
    public suspend fun captionDescriptions(vararg argument: suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("lkwbicqleiberyus")
    public suspend fun captionDescriptions(argument: suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param values Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("tnerkedghbfockuh")
    public suspend fun captionDescriptions(vararg values: ChannelEncoderSettingsCaptionDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionDescriptions = mapped
    }

    /**
     * @param value Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("fdgvhygkoqewfmeg")
    public suspend fun globalConfiguration(`value`: ChannelEncoderSettingsGlobalConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalConfiguration = mapped
    }

    /**
     * @param argument Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("wkaerajvxnwsgmnn")
    public suspend fun globalConfiguration(argument: suspend ChannelEncoderSettingsGlobalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsGlobalConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.globalConfiguration = mapped
    }

    /**
     * @param value Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("nncffutusnndmegg")
    public suspend fun motionGraphicsConfiguration(`value`: ChannelEncoderSettingsMotionGraphicsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.motionGraphicsConfiguration = mapped
    }

    /**
     * @param argument Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("xbanokkqlvkjtfkr")
    public suspend fun motionGraphicsConfiguration(argument: suspend ChannelEncoderSettingsMotionGraphicsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsMotionGraphicsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.motionGraphicsConfiguration = mapped
    }

    /**
     * @param value Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("hcajqrnudkbiucxa")
    public suspend fun nielsenConfiguration(`value`: ChannelEncoderSettingsNielsenConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenConfiguration = mapped
    }

    /**
     * @param argument Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("sbcehbvhmgymfwnj")
    public suspend fun nielsenConfiguration(argument: suspend ChannelEncoderSettingsNielsenConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsNielsenConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nielsenConfiguration = mapped
    }

    /**
     * @param value Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("hlbbunayxwctvsqt")
    public suspend fun outputGroups(`value`: List<ChannelEncoderSettingsOutputGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("cfdgvbbvtfhvoulq")
    public suspend fun outputGroups(argument: List<suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("rbkxhyfdbrklhume")
    public suspend fun outputGroups(vararg argument: suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("halvcxjorgwyjyqh")
    public suspend fun outputGroups(argument: suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param values Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("grmweymihqmbokrl")
    public suspend fun outputGroups(vararg values: ChannelEncoderSettingsOutputGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputGroups = mapped
    }

    /**
     * @param value Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("kcalnuvvfpgalfgx")
    public suspend fun timecodeConfig(`value`: ChannelEncoderSettingsTimecodeConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timecodeConfig = mapped
    }

    /**
     * @param argument Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("gqhlicwipxenxrba")
    public suspend fun timecodeConfig(argument: suspend ChannelEncoderSettingsTimecodeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsTimecodeConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timecodeConfig = mapped
    }

    /**
     * @param value Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("bxivwdxtnpfrukaj")
    public suspend fun videoDescriptions(`value`: List<ChannelEncoderSettingsVideoDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("odkkhwdoecvkwnse")
    public suspend fun videoDescriptions(argument: List<suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("cmfyuvsjokdnsgkm")
    public suspend fun videoDescriptions(vararg argument: suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("avaawpgqnyerxpfb")
    public suspend fun videoDescriptions(argument: suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param values Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("jmlxiocdkryatayd")
    public suspend fun videoDescriptions(vararg values: ChannelEncoderSettingsVideoDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoDescriptions = mapped
    }

    internal fun build(): ChannelEncoderSettingsArgs = ChannelEncoderSettingsArgs(
        audioDescriptions = audioDescriptions,
        availBlanking = availBlanking,
        captionDescriptions = captionDescriptions,
        globalConfiguration = globalConfiguration,
        motionGraphicsConfiguration = motionGraphicsConfiguration,
        nielsenConfiguration = nielsenConfiguration,
        outputGroups = outputGroups ?: throw PulumiNullFieldException("outputGroups"),
        timecodeConfig = timecodeConfig ?: throw PulumiNullFieldException("timecodeConfig"),
        videoDescriptions = videoDescriptions,
    )
}
