@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property audioNormalizationSettings Advanced audio normalization settings. See Audio Normalization Settings for more details.
 * @property audioSelectorName The name of the audio selector used as the source for this AudioDescription.
 * @property audioType Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
 * @property audioTypeControl Determined how audio type is determined.
 * @property audioWatermarkSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode. See Audio Watermark Settings for more details.
 * @property codecSettings Audio codec settings. See Audio Codec Settings for more details.
 * @property languageCode
 * @property languageCodeControl
 * @property name The name of this audio description.
 * @property remixSettings
 * @property streamName Stream name RTMP destinations (URLs of type rtmp://)
 */
public data class ChannelEncoderSettingsAudioDescriptionArgs(
    public val audioNormalizationSettings: Output<ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs>? = null,
    public val audioSelectorName: Output<String>,
    public val audioType: Output<String>? = null,
    public val audioTypeControl: Output<String>? = null,
    public val audioWatermarkSettings: Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgs>? = null,
    public val codecSettings: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs>? = null,
    public val languageCode: Output<String>? = null,
    public val languageCodeControl: Output<String>? = null,
    public val name: Output<String>,
    public val remixSettings: Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs>? = null,
    public val streamName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionArgs = com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionArgs.builder()
        .audioNormalizationSettings(
            audioNormalizationSettings?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .audioSelectorName(audioSelectorName.applyValue({ args0 -> args0 }))
        .audioType(audioType?.applyValue({ args0 -> args0 }))
        .audioTypeControl(audioTypeControl?.applyValue({ args0 -> args0 }))
        .audioWatermarkSettings(
            audioWatermarkSettings?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .codecSettings(codecSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .languageCode(languageCode?.applyValue({ args0 -> args0 }))
        .languageCodeControl(languageCodeControl?.applyValue({ args0 -> args0 }))
        .name(name.applyValue({ args0 -> args0 }))
        .remixSettings(remixSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .streamName(streamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionArgsBuilder internal constructor() {
    private var audioNormalizationSettings:
        Output<ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs>? = null

    private var audioSelectorName: Output<String>? = null

    private var audioType: Output<String>? = null

    private var audioTypeControl: Output<String>? = null

    private var audioWatermarkSettings:
        Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgs>? = null

    private var codecSettings: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs>? = null

    private var languageCode: Output<String>? = null

    private var languageCodeControl: Output<String>? = null

    private var name: Output<String>? = null

    private var remixSettings: Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs>? = null

    private var streamName: Output<String>? = null

    /**
     * @param value Advanced audio normalization settings. See Audio Normalization Settings for more details.
     */
    @JvmName("yaudgwptdgqopmhg")
    public suspend fun audioNormalizationSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs>) {
        this.audioNormalizationSettings = value
    }

    /**
     * @param value The name of the audio selector used as the source for this AudioDescription.
     */
    @JvmName("qqndaupjjdgchtog")
    public suspend fun audioSelectorName(`value`: Output<String>) {
        this.audioSelectorName = value
    }

    /**
     * @param value Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
     */
    @JvmName("ibsbqatdsgeqdpea")
    public suspend fun audioType(`value`: Output<String>) {
        this.audioType = value
    }

    /**
     * @param value Determined how audio type is determined.
     */
    @JvmName("fvvihmxvbnbnilmh")
    public suspend fun audioTypeControl(`value`: Output<String>) {
        this.audioTypeControl = value
    }

    /**
     * @param value Settings to configure one or more solutions that insert audio watermarks in the audio encode. See Audio Watermark Settings for more details.
     */
    @JvmName("cjfvkgmpwdwfqmnk")
    public suspend fun audioWatermarkSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgs>) {
        this.audioWatermarkSettings = value
    }

    /**
     * @param value Audio codec settings. See Audio Codec Settings for more details.
     */
    @JvmName("ouvnyyeiosnaniry")
    public suspend fun codecSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs>) {
        this.codecSettings = value
    }

    /**
     * @param value
     */
    @JvmName("mggkoymvsqvqilhl")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value
     */
    @JvmName("kbocjssxjlhnjoiy")
    public suspend fun languageCodeControl(`value`: Output<String>) {
        this.languageCodeControl = value
    }

    /**
     * @param value The name of this audio description.
     */
    @JvmName("bggirpmkmlmogefa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("wpghmvdvnlhxongi")
    public suspend fun remixSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs>) {
        this.remixSettings = value
    }

    /**
     * @param value Stream name RTMP destinations (URLs of type rtmp://)
     */
    @JvmName("ifaucarbbhinucdf")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value Advanced audio normalization settings. See Audio Normalization Settings for more details.
     */
    @JvmName("nglkjngmnqprndlb")
    public suspend fun audioNormalizationSettings(`value`: ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioNormalizationSettings = mapped
    }

    /**
     * @param argument Advanced audio normalization settings. See Audio Normalization Settings for more details.
     */
    @JvmName("gkyegwlugirmtcna")
    public suspend fun audioNormalizationSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioNormalizationSettings = mapped
    }

    /**
     * @param value The name of the audio selector used as the source for this AudioDescription.
     */
    @JvmName("xsvytxmaymiewmhq")
    public suspend fun audioSelectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioSelectorName = mapped
    }

    /**
     * @param value Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
     */
    @JvmName("rklyojcfbwpyilfa")
    public suspend fun audioType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioType = mapped
    }

    /**
     * @param value Determined how audio type is determined.
     */
    @JvmName("riibdpohcbhexsuu")
    public suspend fun audioTypeControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioTypeControl = mapped
    }

    /**
     * @param value Settings to configure one or more solutions that insert audio watermarks in the audio encode. See Audio Watermark Settings for more details.
     */
    @JvmName("ilgpoeucqkuagybq")
    public suspend fun audioWatermarkSettings(`value`: ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioWatermarkSettings = mapped
    }

    /**
     * @param argument Settings to configure one or more solutions that insert audio watermarks in the audio encode. See Audio Watermark Settings for more details.
     */
    @JvmName("khuhxniifutsifss")
    public suspend fun audioWatermarkSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioWatermarkSettings = mapped
    }

    /**
     * @param value Audio codec settings. See Audio Codec Settings for more details.
     */
    @JvmName("ngevnkltujmfkvhq")
    public suspend fun codecSettings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecSettings = mapped
    }

    /**
     * @param argument Audio codec settings. See Audio Codec Settings for more details.
     */
    @JvmName("cyslixfbpbeuottb")
    public suspend fun codecSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsAudioDescriptionCodecSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codecSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("cfldfsymgqvhjckf")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("jpbqtpebtnngeirn")
    public suspend fun languageCodeControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCodeControl = mapped
    }

    /**
     * @param value The name of this audio description.
     */
    @JvmName("okchdmhbhuvbnmfk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("gdppcyqtpkblyybn")
    public suspend fun remixSettings(`value`: ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remixSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("scidlidiyidjiymp")
    public suspend fun remixSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsAudioDescriptionRemixSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.remixSettings = mapped
    }

    /**
     * @param value Stream name RTMP destinations (URLs of type rtmp://)
     */
    @JvmName("npakmsntmfrqvvjq")
    public suspend fun streamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionArgs =
        ChannelEncoderSettingsAudioDescriptionArgs(
            audioNormalizationSettings = audioNormalizationSettings,
            audioSelectorName = audioSelectorName ?: throw PulumiNullFieldException("audioSelectorName"),
            audioType = audioType,
            audioTypeControl = audioTypeControl,
            audioWatermarkSettings = audioWatermarkSettings,
            codecSettings = codecSettings,
            languageCode = languageCode,
            languageCodeControl = languageCodeControl,
            name = name ?: throw PulumiNullFieldException("name"),
            remixSettings = remixSettings,
            streamName = streamName,
        )
}
