@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property nielsenCbetSettings Used to insert watermarks of type Nielsen CBET. See Nielsen CBET Settings for more details.
 * @property nielsenDistributionType Distribution types to assign to the watermarks. Options are `PROGRAM_CONTENT` and `FINAL_DISTRIBUTOR`.
 * @property nielsenNaesIiNwSettings Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
 */
public data class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs(
    public val nielsenCbetSettings: Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs>? =
        null,
    public val nielsenDistributionType: Output<String>? = null,
    public val nielsenNaesIiNwSettings: Output<List<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs.builder()
            .nielsenCbetSettings(
                nielsenCbetSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nielsenDistributionType(nielsenDistributionType?.applyValue({ args0 -> args0 }))
            .nielsenNaesIiNwSettings(
                nielsenNaesIiNwSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgsBuilder
internal constructor() {
    private var nielsenCbetSettings:
        Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs>? =
        null

    private var nielsenDistributionType: Output<String>? = null

    private var nielsenNaesIiNwSettings:
        Output<List<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>>? =
        null

    /**
     * @param value Used to insert watermarks of type Nielsen CBET. See Nielsen CBET Settings for more details.
     */
    @JvmName("hpsfukephocggrrn")
    public suspend fun nielsenCbetSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs>) {
        this.nielsenCbetSettings = value
    }

    /**
     * @param value Distribution types to assign to the watermarks. Options are `PROGRAM_CONTENT` and `FINAL_DISTRIBUTOR`.
     */
    @JvmName("euggadkutjssybtr")
    public suspend fun nielsenDistributionType(`value`: Output<String>) {
        this.nielsenDistributionType = value
    }

    /**
     * @param value Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("kckhyscgomebtufv")
    public suspend fun nielsenNaesIiNwSettings(`value`: Output<List<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>>) {
        this.nielsenNaesIiNwSettings = value
    }

    @JvmName("xeyvaqqsilenqekg")
    public suspend fun nielsenNaesIiNwSettings(vararg values: Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>) {
        this.nielsenNaesIiNwSettings = Output.all(values.asList())
    }

    /**
     * @param values Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("kkjimwoyesnakjcw")
    public suspend fun nielsenNaesIiNwSettings(values: List<Output<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>>) {
        this.nielsenNaesIiNwSettings = Output.all(values)
    }

    /**
     * @param value Used to insert watermarks of type Nielsen CBET. See Nielsen CBET Settings for more details.
     */
    @JvmName("rjoqrddgltbwodfv")
    public suspend fun nielsenCbetSettings(`value`: ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenCbetSettings = mapped
    }

    /**
     * @param argument Used to insert watermarks of type Nielsen CBET. See Nielsen CBET Settings for more details.
     */
    @JvmName("vvkyhmmvddpbojny")
    public suspend fun nielsenCbetSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nielsenCbetSettings = mapped
    }

    /**
     * @param value Distribution types to assign to the watermarks. Options are `PROGRAM_CONTENT` and `FINAL_DISTRIBUTOR`.
     */
    @JvmName("gxmitksgxjhkqean")
    public suspend fun nielsenDistributionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenDistributionType = mapped
    }

    /**
     * @param value Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("canccdqgvvouqbbr")
    public suspend fun nielsenNaesIiNwSettings(`value`: List<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenNaesIiNwSettings = mapped
    }

    /**
     * @param argument Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("gnkxiwyhdsqvtsfw")
    public suspend fun nielsenNaesIiNwSettings(argument: List<suspend ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nielsenNaesIiNwSettings = mapped
    }

    /**
     * @param argument Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("fsysglwabnwybqlf")
    public suspend fun nielsenNaesIiNwSettings(vararg argument: suspend ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nielsenNaesIiNwSettings = mapped
    }

    /**
     * @param argument Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("cdbdppsvykmgfcsg")
    public suspend fun nielsenNaesIiNwSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.nielsenNaesIiNwSettings = mapped
    }

    /**
     * @param values Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
     */
    @JvmName("dcfegtcuewtnkkph")
    public suspend fun nielsenNaesIiNwSettings(vararg values: ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nielsenNaesIiNwSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsArgs(
            nielsenCbetSettings = nielsenCbetSettings,
            nielsenDistributionType = nielsenDistributionType,
            nielsenNaesIiNwSettings = nielsenNaesIiNwSettings,
        )
}
