@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property inputType Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
 * @property profile AAC profile.
 * @property rateControlMode The rate control mode.
 * @property rawFormat Sets LATM/LOAS AAC output for raw containers.
 * @property sampleRate Sample rate in Hz.
 * @property spec Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
 * @property vbrQuality VBR Quality Level - Only used if rateControlMode is VBR.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs(
    public val bitrate: Output<Double>? = null,
    public val codingMode: Output<String>? = null,
    public val inputType: Output<String>? = null,
    public val profile: Output<String>? = null,
    public val rateControlMode: Output<String>? = null,
    public val rawFormat: Output<String>? = null,
    public val sampleRate: Output<Double>? = null,
    public val spec: Output<String>? = null,
    public val vbrQuality: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .inputType(inputType?.applyValue({ args0 -> args0 }))
            .profile(profile?.applyValue({ args0 -> args0 }))
            .rateControlMode(rateControlMode?.applyValue({ args0 -> args0 }))
            .rawFormat(rawFormat?.applyValue({ args0 -> args0 }))
            .sampleRate(sampleRate?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .vbrQuality(vbrQuality?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgsBuilder internal constructor() {
    private var bitrate: Output<Double>? = null

    private var codingMode: Output<String>? = null

    private var inputType: Output<String>? = null

    private var profile: Output<String>? = null

    private var rateControlMode: Output<String>? = null

    private var rawFormat: Output<String>? = null

    private var sampleRate: Output<Double>? = null

    private var spec: Output<String>? = null

    private var vbrQuality: Output<String>? = null

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("onwcjjeittmkgouk")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("rkhffclyokwdlbcw")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
     */
    @JvmName("ucobayvfdrnhgoti")
    public suspend fun inputType(`value`: Output<String>) {
        this.inputType = value
    }

    /**
     * @param value AAC profile.
     */
    @JvmName("rwgnutvgqjbriirs")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value The rate control mode.
     */
    @JvmName("xljwhoesmprcbgsb")
    public suspend fun rateControlMode(`value`: Output<String>) {
        this.rateControlMode = value
    }

    /**
     * @param value Sets LATM/LOAS AAC output for raw containers.
     */
    @JvmName("pbmbbxcsaqcimfao")
    public suspend fun rawFormat(`value`: Output<String>) {
        this.rawFormat = value
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("kftwbwrcekgjotpa")
    public suspend fun sampleRate(`value`: Output<Double>) {
        this.sampleRate = value
    }

    /**
     * @param value Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     */
    @JvmName("sojxeqfaousqrjsp")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value VBR Quality Level - Only used if rateControlMode is VBR.
     */
    @JvmName("jdrvoqbysbcshcwj")
    public suspend fun vbrQuality(`value`: Output<String>) {
        this.vbrQuality = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("iwubyyvttkfunlav")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("hejkadcahfjnhgmq")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
     */
    @JvmName("peanoqwonalcuijr")
    public suspend fun inputType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputType = mapped
    }

    /**
     * @param value AAC profile.
     */
    @JvmName("mpnlpulmcklcxpnd")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The rate control mode.
     */
    @JvmName("nwtanoydnorsrbxy")
    public suspend fun rateControlMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value Sets LATM/LOAS AAC output for raw containers.
     */
    @JvmName("fsgowrvrrrigsjrr")
    public suspend fun rawFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawFormat = mapped
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("nulpxogxhhredsjr")
    public suspend fun sampleRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleRate = mapped
    }

    /**
     * @param value Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     */
    @JvmName("djvwiauphksxxkvs")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value VBR Quality Level - Only used if rateControlMode is VBR.
     */
    @JvmName("syiytilyygnpkhwu")
    public suspend fun vbrQuality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrQuality = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs(
            bitrate = bitrate,
            codingMode = codingMode,
            inputType = inputType,
            profile = profile,
            rateControlMode = rateControlMode,
            rawFormat = rawFormat,
            sampleRate = sampleRate,
            spec = spec,
            vbrQuality = vbrQuality,
        )
}
