@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property codingMode Dolby Digital Plus with Dolby Atmos coding mode.
 * @property dialnorm Sets the dialnorm for the output.
 * @property drcLine Sets the Dolby dynamic range compression profile.
 * @property drcRf Sets the profile for heavy Dolby dynamic range compression.
 * @property heightTrim Height dimensional trim.
 * @property surroundTrim Surround dimensional trim.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs(
    public val bitrate: Output<Double>? = null,
    public val codingMode: Output<String>? = null,
    public val dialnorm: Output<Double>? = null,
    public val drcLine: Output<String>? = null,
    public val drcRf: Output<String>? = null,
    public val heightTrim: Output<Double>? = null,
    public val surroundTrim: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .dialnorm(dialnorm?.applyValue({ args0 -> args0 }))
            .drcLine(drcLine?.applyValue({ args0 -> args0 }))
            .drcRf(drcRf?.applyValue({ args0 -> args0 }))
            .heightTrim(heightTrim?.applyValue({ args0 -> args0 }))
            .surroundTrim(surroundTrim?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgsBuilder
internal constructor() {
    private var bitrate: Output<Double>? = null

    private var codingMode: Output<String>? = null

    private var dialnorm: Output<Double>? = null

    private var drcLine: Output<String>? = null

    private var drcRf: Output<String>? = null

    private var heightTrim: Output<Double>? = null

    private var surroundTrim: Output<Double>? = null

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("fqxfpgohapvnetrj")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value Dolby Digital Plus with Dolby Atmos coding mode.
     */
    @JvmName("wvntgwtoghtbrkfj")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value Sets the dialnorm for the output.
     */
    @JvmName("lxxagfepfdecobto")
    public suspend fun dialnorm(`value`: Output<Double>) {
        this.dialnorm = value
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("dqvcokgpilojcnwx")
    public suspend fun drcLine(`value`: Output<String>) {
        this.drcLine = value
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("khpgwulddkqaifnj")
    public suspend fun drcRf(`value`: Output<String>) {
        this.drcRf = value
    }

    /**
     * @param value Height dimensional trim.
     */
    @JvmName("lphccyxevasdqjpp")
    public suspend fun heightTrim(`value`: Output<Double>) {
        this.heightTrim = value
    }

    /**
     * @param value Surround dimensional trim.
     */
    @JvmName("ydbokqwfgkmalsgo")
    public suspend fun surroundTrim(`value`: Output<Double>) {
        this.surroundTrim = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("fmthqxikputupywy")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Dolby Digital Plus with Dolby Atmos coding mode.
     */
    @JvmName("ypvjboegxgghdaif")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value Sets the dialnorm for the output.
     */
    @JvmName("jxyfjmhgjqjwwhgu")
    public suspend fun dialnorm(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialnorm = mapped
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("lrqxwyvqavrybgxm")
    public suspend fun drcLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcLine = mapped
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("uegoebktcqknjxvy")
    public suspend fun drcRf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcRf = mapped
    }

    /**
     * @param value Height dimensional trim.
     */
    @JvmName("mdbjelugsvhicagf")
    public suspend fun heightTrim(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.heightTrim = mapped
    }

    /**
     * @param value Surround dimensional trim.
     */
    @JvmName("xydctwxwjrmorhfa")
    public suspend fun surroundTrim(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surroundTrim = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs(
            bitrate = bitrate,
            codingMode = codingMode,
            dialnorm = dialnorm,
            drcLine = drcLine,
            drcRf = drcRf,
            heightTrim = heightTrim,
            surroundTrim = surroundTrim,
        )
}
