@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attenuationControl Sets the attenuation control.
 * @property bitrate Average bitrate in bits/second.
 * @property bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
 * @property codingMode Dolby Digital Plus coding mode.
 * @property dcFilter
 * @property dialnorm
 * @property drcLine Sets the Dolby dynamic range compression profile.
 * @property drcRf Sets the profile for heavy Dolby dynamic range compression.
 * @property lfeControl
 * @property lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
 * @property loRoCenterMixLevel
 * @property loRoSurroundMixLevel
 * @property ltRtCenterMixLevel
 * @property ltRtSurroundMixLevel
 * @property metadataControl Metadata control.
 * @property passthroughControl
 * @property phaseControl
 * @property stereoDownmix
 * @property surroundExMode
 * @property surroundMode
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs(
    public val attenuationControl: Output<String>? = null,
    public val bitrate: Output<Double>? = null,
    public val bitstreamMode: Output<String>? = null,
    public val codingMode: Output<String>? = null,
    public val dcFilter: Output<String>? = null,
    public val dialnorm: Output<Int>? = null,
    public val drcLine: Output<String>? = null,
    public val drcRf: Output<String>? = null,
    public val lfeControl: Output<String>? = null,
    public val lfeFilter: Output<String>? = null,
    public val loRoCenterMixLevel: Output<Double>? = null,
    public val loRoSurroundMixLevel: Output<Double>? = null,
    public val ltRtCenterMixLevel: Output<Double>? = null,
    public val ltRtSurroundMixLevel: Output<Double>? = null,
    public val metadataControl: Output<String>? = null,
    public val passthroughControl: Output<String>? = null,
    public val phaseControl: Output<String>? = null,
    public val stereoDownmix: Output<String>? = null,
    public val surroundExMode: Output<String>? = null,
    public val surroundMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs.builder()
            .attenuationControl(attenuationControl?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bitstreamMode(bitstreamMode?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .dcFilter(dcFilter?.applyValue({ args0 -> args0 }))
            .dialnorm(dialnorm?.applyValue({ args0 -> args0 }))
            .drcLine(drcLine?.applyValue({ args0 -> args0 }))
            .drcRf(drcRf?.applyValue({ args0 -> args0 }))
            .lfeControl(lfeControl?.applyValue({ args0 -> args0 }))
            .lfeFilter(lfeFilter?.applyValue({ args0 -> args0 }))
            .loRoCenterMixLevel(loRoCenterMixLevel?.applyValue({ args0 -> args0 }))
            .loRoSurroundMixLevel(loRoSurroundMixLevel?.applyValue({ args0 -> args0 }))
            .ltRtCenterMixLevel(ltRtCenterMixLevel?.applyValue({ args0 -> args0 }))
            .ltRtSurroundMixLevel(ltRtSurroundMixLevel?.applyValue({ args0 -> args0 }))
            .metadataControl(metadataControl?.applyValue({ args0 -> args0 }))
            .passthroughControl(passthroughControl?.applyValue({ args0 -> args0 }))
            .phaseControl(phaseControl?.applyValue({ args0 -> args0 }))
            .stereoDownmix(stereoDownmix?.applyValue({ args0 -> args0 }))
            .surroundExMode(surroundExMode?.applyValue({ args0 -> args0 }))
            .surroundMode(surroundMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgsBuilder internal constructor() {
    private var attenuationControl: Output<String>? = null

    private var bitrate: Output<Double>? = null

    private var bitstreamMode: Output<String>? = null

    private var codingMode: Output<String>? = null

    private var dcFilter: Output<String>? = null

    private var dialnorm: Output<Int>? = null

    private var drcLine: Output<String>? = null

    private var drcRf: Output<String>? = null

    private var lfeControl: Output<String>? = null

    private var lfeFilter: Output<String>? = null

    private var loRoCenterMixLevel: Output<Double>? = null

    private var loRoSurroundMixLevel: Output<Double>? = null

    private var ltRtCenterMixLevel: Output<Double>? = null

    private var ltRtSurroundMixLevel: Output<Double>? = null

    private var metadataControl: Output<String>? = null

    private var passthroughControl: Output<String>? = null

    private var phaseControl: Output<String>? = null

    private var stereoDownmix: Output<String>? = null

    private var surroundExMode: Output<String>? = null

    private var surroundMode: Output<String>? = null

    /**
     * @param value Sets the attenuation control.
     */
    @JvmName("kklajpfscbsqnosj")
    public suspend fun attenuationControl(`value`: Output<String>) {
        this.attenuationControl = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("phytmlsdkduiubxg")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("qyodanxaqixypgbi")
    public suspend fun bitstreamMode(`value`: Output<String>) {
        this.bitstreamMode = value
    }

    /**
     * @param value Dolby Digital Plus coding mode.
     */
    @JvmName("yolssxyxprilxcxh")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value
     */
    @JvmName("nruplwxnvwbbxjxo")
    public suspend fun dcFilter(`value`: Output<String>) {
        this.dcFilter = value
    }

    /**
     * @param value
     */
    @JvmName("uxqchhiqproevlte")
    public suspend fun dialnorm(`value`: Output<Int>) {
        this.dialnorm = value
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("dvexdumuxvxckfib")
    public suspend fun drcLine(`value`: Output<String>) {
        this.drcLine = value
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("vtwjddrrfgocuace")
    public suspend fun drcRf(`value`: Output<String>) {
        this.drcRf = value
    }

    /**
     * @param value
     */
    @JvmName("odviulpsiyqqgrom")
    public suspend fun lfeControl(`value`: Output<String>) {
        this.lfeControl = value
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("gwuooyhvdlfwigiu")
    public suspend fun lfeFilter(`value`: Output<String>) {
        this.lfeFilter = value
    }

    /**
     * @param value
     */
    @JvmName("qxtyvfowwlgicvyj")
    public suspend fun loRoCenterMixLevel(`value`: Output<Double>) {
        this.loRoCenterMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("trokmjpcunctyjuc")
    public suspend fun loRoSurroundMixLevel(`value`: Output<Double>) {
        this.loRoSurroundMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("nkksedobpeisytjj")
    public suspend fun ltRtCenterMixLevel(`value`: Output<Double>) {
        this.ltRtCenterMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("qrnguycodaecsdjb")
    public suspend fun ltRtSurroundMixLevel(`value`: Output<Double>) {
        this.ltRtSurroundMixLevel = value
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("lpdoltjsgouqswkw")
    public suspend fun metadataControl(`value`: Output<String>) {
        this.metadataControl = value
    }

    /**
     * @param value
     */
    @JvmName("hogpjruhswgwhpab")
    public suspend fun passthroughControl(`value`: Output<String>) {
        this.passthroughControl = value
    }

    /**
     * @param value
     */
    @JvmName("hwgvobadnekjftoa")
    public suspend fun phaseControl(`value`: Output<String>) {
        this.phaseControl = value
    }

    /**
     * @param value
     */
    @JvmName("fjdwrhusiwwlcnsn")
    public suspend fun stereoDownmix(`value`: Output<String>) {
        this.stereoDownmix = value
    }

    /**
     * @param value
     */
    @JvmName("conmmbusggpywsmg")
    public suspend fun surroundExMode(`value`: Output<String>) {
        this.surroundExMode = value
    }

    /**
     * @param value
     */
    @JvmName("kljryfxogpypgbdu")
    public suspend fun surroundMode(`value`: Output<String>) {
        this.surroundMode = value
    }

    /**
     * @param value Sets the attenuation control.
     */
    @JvmName("ldavvdhfgwxhldjh")
    public suspend fun attenuationControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attenuationControl = mapped
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("vfwodyxumcqxmwjk")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("jvdaidnmvysbneqe")
    public suspend fun bitstreamMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitstreamMode = mapped
    }

    /**
     * @param value Dolby Digital Plus coding mode.
     */
    @JvmName("pgpcljcsamjrmjbu")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("dxmbhrisfjjhvdkg")
    public suspend fun dcFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dcFilter = mapped
    }

    /**
     * @param value
     */
    @JvmName("vdttjhwmviedxfvm")
    public suspend fun dialnorm(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialnorm = mapped
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("cstboqtbhlkungyg")
    public suspend fun drcLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcLine = mapped
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("yjjmtbudqpydlxgf")
    public suspend fun drcRf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcRf = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptijrfijatfdtrxc")
    public suspend fun lfeControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfeControl = mapped
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("wrwlcahbqoakxvfo")
    public suspend fun lfeFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfeFilter = mapped
    }

    /**
     * @param value
     */
    @JvmName("njcjduwcivwypyda")
    public suspend fun loRoCenterMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loRoCenterMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("orwrbbkictwixkcj")
    public suspend fun loRoSurroundMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loRoSurroundMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("vboinsmmjspcikam")
    public suspend fun ltRtCenterMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltRtCenterMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("aciroarakqdhqebt")
    public suspend fun ltRtSurroundMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltRtSurroundMixLevel = mapped
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("jnuornipiexlcjkg")
    public suspend fun metadataControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("iudvovvqmaikbwck")
    public suspend fun passthroughControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passthroughControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("ebmuxqmejyxwrmrv")
    public suspend fun phaseControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phaseControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghrjaqpltuinuqxc")
    public suspend fun stereoDownmix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stereoDownmix = mapped
    }

    /**
     * @param value
     */
    @JvmName("hmiikeijilhnfvby")
    public suspend fun surroundExMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surroundExMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("lncgmejusoajeapw")
    public suspend fun surroundMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surroundMode = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs(
            attenuationControl = attenuationControl,
            bitrate = bitrate,
            bitstreamMode = bitstreamMode,
            codingMode = codingMode,
            dcFilter = dcFilter,
            dialnorm = dialnorm,
            drcLine = drcLine,
            drcRf = drcRf,
            lfeControl = lfeControl,
            lfeFilter = lfeFilter,
            loRoCenterMixLevel = loRoCenterMixLevel,
            loRoSurroundMixLevel = loRoSurroundMixLevel,
            ltRtCenterMixLevel = ltRtCenterMixLevel,
            ltRtSurroundMixLevel = ltRtSurroundMixLevel,
            metadataControl = metadataControl,
            passthroughControl = passthroughControl,
            phaseControl = phaseControl,
            stereoDownmix = stereoDownmix,
            surroundExMode = surroundExMode,
            surroundMode = surroundMode,
        )
}
