@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitrate
 * @property codingMode
 * @property sampleRate Sample rate in Hz.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs(
    public val bitrate: Output<Double>? = null,
    public val codingMode: Output<String>? = null,
    public val sampleRate: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .sampleRate(sampleRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgsBuilder internal constructor() {
    private var bitrate: Output<Double>? = null

    private var codingMode: Output<String>? = null

    private var sampleRate: Output<Double>? = null

    /**
     * @param value
     */
    @JvmName("tymtodekotxhilsw")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value
     */
    @JvmName("cglamkokisqmskbm")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("gyvtlgaxbfxooqhl")
    public suspend fun sampleRate(`value`: Output<Double>) {
        this.sampleRate = value
    }

    /**
     * @param value
     */
    @JvmName("hoglxmoqypflbxhv")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("vlmhjdwskrlippaq")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("qxpkllddntfxqatc")
    public suspend fun sampleRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleRate = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs(
            bitrate = bitrate,
            codingMode = codingMode,
            sampleRate = sampleRate,
        )
}
