@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitDepth
 * @property codingMode
 * @property sampleRate Sample rate in Hz.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs(
    public val bitDepth: Output<Double>? = null,
    public val codingMode: Output<String>? = null,
    public val sampleRate: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs.builder()
            .bitDepth(bitDepth?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .sampleRate(sampleRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgsBuilder internal constructor() {
    private var bitDepth: Output<Double>? = null

    private var codingMode: Output<String>? = null

    private var sampleRate: Output<Double>? = null

    /**
     * @param value
     */
    @JvmName("sbujuxoejxlnxprn")
    public suspend fun bitDepth(`value`: Output<Double>) {
        this.bitDepth = value
    }

    /**
     * @param value
     */
    @JvmName("heyhpomrxbtlafsi")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("aprtqbbbyqbyawrn")
    public suspend fun sampleRate(`value`: Output<Double>) {
        this.sampleRate = value
    }

    /**
     * @param value
     */
    @JvmName("juwnoylxnkykktqi")
    public suspend fun bitDepth(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitDepth = mapped
    }

    /**
     * @param value
     */
    @JvmName("dypdqrhujcpyntmg")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value Sample rate in Hz.
     */
    @JvmName("lpokgiufeplbnnkk")
    public suspend fun sampleRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleRate = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs(
            bitDepth = bitDepth,
            codingMode = codingMode,
            sampleRate = sampleRate,
        )
}
