@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property channelMappings
 * @property channelsIn
 * @property channelsOut
 */
public data class ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs(
    public val channelMappings: Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>>,
    public val channelsIn: Output<Int>? = null,
    public val channelsOut: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs.builder()
            .channelMappings(
                channelMappings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .channelsIn(channelsIn?.applyValue({ args0 -> args0 }))
            .channelsOut(channelsOut?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionRemixSettingsArgsBuilder internal constructor() {
    private var channelMappings:
        Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>>? = null

    private var channelsIn: Output<Int>? = null

    private var channelsOut: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("aqqhfadodsopvweu")
    public suspend fun channelMappings(`value`: Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>>) {
        this.channelMappings = value
    }

    @JvmName("kgvvrstjogsckntn")
    public suspend fun channelMappings(vararg values: Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>) {
        this.channelMappings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fgyoutigpmsoybwc")
    public suspend fun channelMappings(values: List<Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>>) {
        this.channelMappings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xxcypojknomxbkla")
    public suspend fun channelsIn(`value`: Output<Int>) {
        this.channelsIn = value
    }

    /**
     * @param value
     */
    @JvmName("apdoljosmbhipmhl")
    public suspend fun channelsOut(`value`: Output<Int>) {
        this.channelsOut = value
    }

    /**
     * @param value
     */
    @JvmName("qtiaelalblyxlnnl")
    public suspend fun channelMappings(`value`: List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ljjvcupeddhldofw")
    public suspend fun channelMappings(argument: List<suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.channelMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("knyufqnpvheiiovw")
    public suspend fun channelMappings(vararg argument: suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.channelMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("twnyvncbrgocsxsx")
    public suspend fun channelMappings(argument: suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.channelMappings = mapped
    }

    /**
     * @param values
     */
    @JvmName("xsvhqkrleebqiwls")
    public suspend fun channelMappings(vararg values: ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMappings = mapped
    }

    /**
     * @param value
     */
    @JvmName("ldxdlpvdgtudpnax")
    public suspend fun channelsIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsIn = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpaitsspwrfmpewv")
    public suspend fun channelsOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsOut = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionRemixSettingsArgs(
            channelMappings = channelMappings ?: throw PulumiNullFieldException("channelMappings"),
            channelsIn = channelsIn,
            channelsOut = channelsOut,
        )
}
