@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property inputChannelLevels
 * @property outputChannel
 */
public data class ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs(
    public val inputChannelLevels: Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>>,
    public val outputChannel: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs.builder()
            .inputChannelLevels(
                inputChannelLevels.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outputChannel(outputChannel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgsBuilder internal constructor() {
    private var inputChannelLevels:
        Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>>? =
        null

    private var outputChannel: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("wdoyixmqfrcadgyt")
    public suspend fun inputChannelLevels(`value`: Output<List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>>) {
        this.inputChannelLevels = value
    }

    @JvmName("gkydfyfakoyjsggk")
    public suspend fun inputChannelLevels(vararg values: Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>) {
        this.inputChannelLevels = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("draducgpucdeplxd")
    public suspend fun inputChannelLevels(values: List<Output<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>>) {
        this.inputChannelLevels = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xberwntehycwojji")
    public suspend fun outputChannel(`value`: Output<Int>) {
        this.outputChannel = value
    }

    /**
     * @param value
     */
    @JvmName("darsygajxdnjykcv")
    public suspend fun inputChannelLevels(`value`: List<ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputChannelLevels = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tpkrpvgqvbrjubaa")
    public suspend fun inputChannelLevels(argument: List<suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputChannelLevels = mapped
    }

    /**
     * @param argument
     */
    @JvmName("owknybujoayurhpa")
    public suspend fun inputChannelLevels(vararg argument: suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputChannelLevels = mapped
    }

    /**
     * @param argument
     */
    @JvmName("subsydhsiktdytht")
    public suspend fun inputChannelLevels(argument: suspend ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.inputChannelLevels = mapped
    }

    /**
     * @param values
     */
    @JvmName("vwakodaxfperhpqc")
    public suspend fun inputChannelLevels(vararg values: ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingInputChannelLevelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputChannelLevels = mapped
    }

    /**
     * @param value
     */
    @JvmName("swhydovcrmttsfyu")
    public suspend fun outputChannel(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputChannel = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs =
        ChannelEncoderSettingsAudioDescriptionRemixSettingsChannelMappingArgs(
            inputChannelLevels = inputChannelLevels ?: throw PulumiNullFieldException("inputChannelLevels"),
            outputChannel = outputChannel ?: throw PulumiNullFieldException("outputChannel"),
        )
}
