@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordParam Key used to extract the password from EC2 Parameter store.
 * @property uri Path to a file accessible to the live stream.
 * @property username . Username to be used.
 */
public data class ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs(
    public val passwordParam: Output<String>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs.builder()
            .passwordParam(passwordParam?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgsBuilder internal constructor() {
    private var passwordParam: Output<String>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("vgiydijyysvobgxm")
    public suspend fun passwordParam(`value`: Output<String>) {
        this.passwordParam = value
    }

    /**
     * @param value Path to a file accessible to the live stream.
     */
    @JvmName("tuymovrvpbgliiiw")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value . Username to be used.
     */
    @JvmName("tqvxrnctvjccqcyv")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("onwejnmloqmfuoam")
    public suspend fun passwordParam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordParam = mapped
    }

    /**
     * @param value Path to a file accessible to the live stream.
     */
    @JvmName("euyigdvcykqoavat")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value . Username to be used.
     */
    @JvmName("ivgmsmdmcexmfdbb")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs =
        ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs(
            passwordParam = passwordParam,
            uri = uri ?: throw PulumiNullFieldException("uri"),
            username = username,
        )
}
