@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessibility Indicates whether the caption track implements accessibility features such as written descriptions of spoken dialog, music, and sounds.
 * @property captionSelectorName Specifies which input caption selector to use as a caption source when generating output captions. This field should match a captionSelector name.
 * @property destinationSettings Additional settings for captions destination that depend on the destination type. See Destination Settings for more details.
 * @property languageCode ISO 639-2 three-digit code.
 * @property languageDescription Human readable information to indicate captions available for players (eg. English, or Spanish).
 * @property name Name of the caption description. Used to associate a caption description with an output. Names must be unique within an event.
 */
public data class ChannelEncoderSettingsCaptionDescriptionArgs(
    public val accessibility: Output<String>? = null,
    public val captionSelectorName: Output<String>,
    public val destinationSettings: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs>? = null,
    public val languageCode: Output<String>? = null,
    public val languageDescription: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionArgs.builder()
            .accessibility(accessibility?.applyValue({ args0 -> args0 }))
            .captionSelectorName(captionSelectorName.applyValue({ args0 -> args0 }))
            .destinationSettings(
                destinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .languageDescription(languageDescription?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsCaptionDescriptionArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsCaptionDescriptionArgsBuilder internal constructor() {
    private var accessibility: Output<String>? = null

    private var captionSelectorName: Output<String>? = null

    private var destinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs>? = null

    private var languageCode: Output<String>? = null

    private var languageDescription: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Indicates whether the caption track implements accessibility features such as written descriptions of spoken dialog, music, and sounds.
     */
    @JvmName("pikavtwbfrdbqdlx")
    public suspend fun accessibility(`value`: Output<String>) {
        this.accessibility = value
    }

    /**
     * @param value Specifies which input caption selector to use as a caption source when generating output captions. This field should match a captionSelector name.
     */
    @JvmName("aafxoymfevawvdcb")
    public suspend fun captionSelectorName(`value`: Output<String>) {
        this.captionSelectorName = value
    }

    /**
     * @param value Additional settings for captions destination that depend on the destination type. See Destination Settings for more details.
     */
    @JvmName("tmrgqsqybixgkwji")
    public suspend fun destinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs>) {
        this.destinationSettings = value
    }

    /**
     * @param value ISO 639-2 three-digit code.
     */
    @JvmName("ebfjsrsxdkbuyttg")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    @JvmName("mlpttkfdtrjirwtj")
    public suspend fun languageDescription(`value`: Output<String>) {
        this.languageDescription = value
    }

    /**
     * @param value Name of the caption description. Used to associate a caption description with an output. Names must be unique within an event.
     */
    @JvmName("ppfhkpsfkughyiar")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether the caption track implements accessibility features such as written descriptions of spoken dialog, music, and sounds.
     */
    @JvmName("raiyllyjpeikusbp")
    public suspend fun accessibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessibility = mapped
    }

    /**
     * @param value Specifies which input caption selector to use as a caption source when generating output captions. This field should match a captionSelector name.
     */
    @JvmName("samtwumrjllhdnxo")
    public suspend fun captionSelectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionSelectorName = mapped
    }

    /**
     * @param value Additional settings for captions destination that depend on the destination type. See Destination Settings for more details.
     */
    @JvmName("doviltputmxsnvjv")
    public suspend fun destinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationSettings = mapped
    }

    /**
     * @param argument Additional settings for captions destination that depend on the destination type. See Destination Settings for more details.
     */
    @JvmName("pxdrskalrjyhywbk")
    public suspend fun destinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destinationSettings = mapped
    }

    /**
     * @param value ISO 639-2 three-digit code.
     */
    @JvmName("uyrqpjxrtursvdhf")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    @JvmName("etqdovhgevnmrpdc")
    public suspend fun languageDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageDescription = mapped
    }

    /**
     * @param value Name of the caption description. Used to associate a caption description with an output. Names must be unique within an event.
     */
    @JvmName("vohemcmpbdgwwxlh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ChannelEncoderSettingsCaptionDescriptionArgs =
        ChannelEncoderSettingsCaptionDescriptionArgs(
            accessibility = accessibility,
            captionSelectorName = captionSelectorName ?: throw PulumiNullFieldException("captionSelectorName"),
            destinationSettings = destinationSettings,
            languageCode = languageCode,
            languageDescription = languageDescription,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
