@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property styleControl Controls whether the color and position of the source captions is passed through to the WebVTT output captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO\_STYLE\_DATA - Don’t pass through the style. The output captions will not contain any font styling information.
 */
public data class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs(
    public val styleControl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs.builder()
            .styleControl(styleControl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgsBuilder
internal constructor() {
    private var styleControl: Output<String>? = null

    /**
     * @param value Controls whether the color and position of the source captions is passed through to the WebVTT output captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO\_STYLE\_DATA - Don’t pass through the style. The output captions will not contain any font styling information.
     */
    @JvmName("tgifghvtjwalecbl")
    public suspend fun styleControl(`value`: Output<String>) {
        this.styleControl = value
    }

    /**
     * @param value Controls whether the color and position of the source captions is passed through to the WebVTT output captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO\_STYLE\_DATA - Don’t pass through the style. The output captions will not contain any font styling information.
     */
    @JvmName("scbotacfjneflcte")
    public suspend fun styleControl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.styleControl = mapped
    }

    internal fun build(): ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs =
        ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs(
            styleControl = styleControl ?: throw PulumiNullFieldException("styleControl"),
        )
}
