@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property blackFrameMsec
 * @property inputLossImageColor
 * @property inputLossImageSlate
 * @property inputLossImageType
 * @property repeatFrameMsec
 */
public data class ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs(
    public val blackFrameMsec: Output<Int>? = null,
    public val inputLossImageColor: Output<String>? = null,
    public val inputLossImageSlate: Output<ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs>? =
        null,
    public val inputLossImageType: Output<String>? = null,
    public val repeatFrameMsec: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs.builder()
            .blackFrameMsec(blackFrameMsec?.applyValue({ args0 -> args0 }))
            .inputLossImageColor(inputLossImageColor?.applyValue({ args0 -> args0 }))
            .inputLossImageSlate(
                inputLossImageSlate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .inputLossImageType(inputLossImageType?.applyValue({ args0 -> args0 }))
            .repeatFrameMsec(repeatFrameMsec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgsBuilder internal constructor() {
    private var blackFrameMsec: Output<Int>? = null

    private var inputLossImageColor: Output<String>? = null

    private var inputLossImageSlate:
        Output<ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs>? =
        null

    private var inputLossImageType: Output<String>? = null

    private var repeatFrameMsec: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("jtjsrxenmgpviqfj")
    public suspend fun blackFrameMsec(`value`: Output<Int>) {
        this.blackFrameMsec = value
    }

    /**
     * @param value
     */
    @JvmName("jcsycdtdudepnggp")
    public suspend fun inputLossImageColor(`value`: Output<String>) {
        this.inputLossImageColor = value
    }

    /**
     * @param value
     */
    @JvmName("ekjndcetjddqthmb")
    public suspend fun inputLossImageSlate(`value`: Output<ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs>) {
        this.inputLossImageSlate = value
    }

    /**
     * @param value
     */
    @JvmName("bxoqtjqcyytoaibn")
    public suspend fun inputLossImageType(`value`: Output<String>) {
        this.inputLossImageType = value
    }

    /**
     * @param value
     */
    @JvmName("cdckiwdqetarwxwo")
    public suspend fun repeatFrameMsec(`value`: Output<Int>) {
        this.repeatFrameMsec = value
    }

    /**
     * @param value
     */
    @JvmName("ticflbmpcykfnyme")
    public suspend fun blackFrameMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blackFrameMsec = mapped
    }

    /**
     * @param value
     */
    @JvmName("junpjfvynpnurcrk")
    public suspend fun inputLossImageColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossImageColor = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvivarlfyijkydhr")
    public suspend fun inputLossImageSlate(`value`: ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossImageSlate = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nlqtxgoqcgsnfccq")
    public suspend fun inputLossImageSlate(argument: suspend ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputLossImageSlate = mapped
    }

    /**
     * @param value
     */
    @JvmName("scoirkyenlhdhehe")
    public suspend fun inputLossImageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossImageType = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmogapoqqlfeghfi")
    public suspend fun repeatFrameMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatFrameMsec = mapped
    }

    internal fun build(): ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs =
        ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorArgs(
            blackFrameMsec = blackFrameMsec,
            inputLossImageColor = inputLossImageColor,
            inputLossImageSlate = inputLossImageSlate,
            inputLossImageType = inputLossImageType,
            repeatFrameMsec = repeatFrameMsec,
        )
}
