@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordParam
 * @property uri
 * @property username
 */
public data class ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs(
    public val passwordParam: Output<String>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs.builder()
            .passwordParam(passwordParam?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgsBuilder
internal constructor() {
    private var passwordParam: Output<String>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("llqiubatuonsqgvg")
    public suspend fun passwordParam(`value`: Output<String>) {
        this.passwordParam = value
    }

    /**
     * @param value
     */
    @JvmName("xjyswohrtbfwycpu")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value
     */
    @JvmName("cjsiumfwmiufrtpe")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value
     */
    @JvmName("oraqgekxhxipvkfb")
    public suspend fun passwordParam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordParam = mapped
    }

    /**
     * @param value
     */
    @JvmName("ighhkqmwnjxhfnlj")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value
     */
    @JvmName("ffjfqkykwphfsfkn")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs =
        ChannelEncoderSettingsGlobalConfigurationInputLossBehaviorInputLossImageSlateArgs(
            passwordParam = passwordParam,
            uri = uri ?: throw PulumiNullFieldException("uri"),
            username = username,
        )
}
