@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property htmlMotionGraphicsSettings Html Motion Graphics Settings.
 */
public data class ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs(
    public val htmlMotionGraphicsSettings: Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs.builder()
            .htmlMotionGraphicsSettings(
                htmlMotionGraphicsSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgsBuilder
internal constructor() {
    private var htmlMotionGraphicsSettings:
        Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgs>? =
        null

    /**
     * @param value Html Motion Graphics Settings.
     */
    @JvmName("mqbqvsenpcmsricl")
    public suspend fun htmlMotionGraphicsSettings(`value`: Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgs>) {
        this.htmlMotionGraphicsSettings = value
    }

    /**
     * @param value Html Motion Graphics Settings.
     */
    @JvmName("xmwewxvwoonpstqt")
    public suspend fun htmlMotionGraphicsSettings(`value`: ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.htmlMotionGraphicsSettings = mapped
    }

    /**
     * @param argument Html Motion Graphics Settings.
     */
    @JvmName("jccjuwipldrgcgsq")
    public suspend fun htmlMotionGraphicsSettings(argument: suspend ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsHtmlMotionGraphicsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.htmlMotionGraphicsSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs = ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs(
        htmlMotionGraphicsSettings = htmlMotionGraphicsSettings,
    )
}
