@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsNielsenConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property distributorId Enter the Distributor ID assigned to your organization by Nielsen.
 * @property nielsenPcmToId3Tagging Enables Nielsen PCM to ID3 tagging.
 */
public data class ChannelEncoderSettingsNielsenConfigurationArgs(
    public val distributorId: Output<String>? = null,
    public val nielsenPcmToId3Tagging: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsNielsenConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsNielsenConfigurationArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsNielsenConfigurationArgs.builder()
            .distributorId(distributorId?.applyValue({ args0 -> args0 }))
            .nielsenPcmToId3Tagging(nielsenPcmToId3Tagging?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsNielsenConfigurationArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsNielsenConfigurationArgsBuilder internal constructor() {
    private var distributorId: Output<String>? = null

    private var nielsenPcmToId3Tagging: Output<String>? = null

    /**
     * @param value Enter the Distributor ID assigned to your organization by Nielsen.
     */
    @JvmName("elqhlmwrfvsbfbay")
    public suspend fun distributorId(`value`: Output<String>) {
        this.distributorId = value
    }

    /**
     * @param value Enables Nielsen PCM to ID3 tagging.
     */
    @JvmName("yvrwiexhsxxcuuvn")
    public suspend fun nielsenPcmToId3Tagging(`value`: Output<String>) {
        this.nielsenPcmToId3Tagging = value
    }

    /**
     * @param value Enter the Distributor ID assigned to your organization by Nielsen.
     */
    @JvmName("yfbqspxeenutggbt")
    public suspend fun distributorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributorId = mapped
    }

    /**
     * @param value Enables Nielsen PCM to ID3 tagging.
     */
    @JvmName("wevsdtilpokwqcwh")
    public suspend fun nielsenPcmToId3Tagging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenPcmToId3Tagging = mapped
    }

    internal fun build(): ChannelEncoderSettingsNielsenConfigurationArgs =
        ChannelEncoderSettingsNielsenConfigurationArgs(
            distributorId = distributorId,
            nielsenPcmToId3Tagging = nielsenPcmToId3Tagging,
        )
}
