@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property archiveCdnSettings Parameters that control the interactions with the CDN. See Archive CDN Settings for more details.
 * @property destination A director and base filename where archive files should be written. See Destination for more details.
 * @property rolloverInterval Number of seconds to write to archive file before closing and starting a new one.
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs(
    public val archiveCdnSettings: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgs>? =
        null,
    public val destination: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs>,
    public val rolloverInterval: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs.builder()
            .archiveCdnSettings(
                archiveCdnSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rolloverInterval(rolloverInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder
internal constructor() {
    private var archiveCdnSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgs>? =
        null

    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs>? =
        null

    private var rolloverInterval: Output<Int>? = null

    /**
     * @param value Parameters that control the interactions with the CDN. See Archive CDN Settings for more details.
     */
    @JvmName("fhsqibovjfckiwjf")
    public suspend fun archiveCdnSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgs>) {
        this.archiveCdnSettings = value
    }

    /**
     * @param value A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("tlegbrmdecbnijmc")
    public suspend fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Number of seconds to write to archive file before closing and starting a new one.
     */
    @JvmName("pfrkdkydupisamfj")
    public suspend fun rolloverInterval(`value`: Output<Int>) {
        this.rolloverInterval = value
    }

    /**
     * @param value Parameters that control the interactions with the CDN. See Archive CDN Settings for more details.
     */
    @JvmName("qlwjkopvjoripubv")
    public suspend fun archiveCdnSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveCdnSettings = mapped
    }

    /**
     * @param argument Parameters that control the interactions with the CDN. See Archive CDN Settings for more details.
     */
    @JvmName("dbblslnmbbrdohsm")
    public suspend fun archiveCdnSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.archiveCdnSettings = mapped
    }

    /**
     * @param value A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("oxbyqrpqympxsexu")
    public suspend fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("eubewqboexsbltif")
    public suspend fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Number of seconds to write to archive file before closing and starting a new one.
     */
    @JvmName("yjgkgyfghfsscika")
    public suspend fun rolloverInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rolloverInterval = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs = ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs(
        archiveCdnSettings = archiveCdnSettings,
        destination = destination ?: throw PulumiNullFieldException("destination"),
        rolloverInterval = rolloverInterval,
    )
}
