@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adMarkers The ad marker type for this output group.
 * @property baseUrlContent
 * @property baseUrlContent1
 * @property baseUrlManifest
 * @property baseUrlManifest1
 * @property captionLanguageMappings
 * @property captionLanguageSetting
 * @property clientCache
 * @property codecSpecification
 * @property constantIv
 * @property destination
 * @property directoryStructure
 * @property discontinuityTags
 * @property encryptionType
 * @property hlsCdnSettings
 * @property hlsId3SegmentTagging
 * @property iframeOnlyPlaylists
 * @property incompleteSegmentBehavior
 * @property indexNSegments
 * @property inputLossAction
 * @property ivInManifest
 * @property ivSource
 * @property keepSegments
 * @property keyFormat
 * @property keyFormatVersions
 * @property keyProviderSettings
 * @property manifestCompression
 * @property manifestDurationFormat
 * @property minSegmentLength
 * @property mode
 * @property outputSelection
 * @property programDateTime
 * @property programDateTimeClock
 * @property programDateTimePeriod
 * @property redundantManifest
 * @property segmentLength
 * @property segmentsPerSubdirectory
 * @property streamInfResolution
 * @property timedMetadataId3Frame Indicates ID3 frame that has the timecode.
 * @property timedMetadataId3Period
 * @property timestampDeltaMilliseconds
 * @property tsFileMode
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs(
    public val adMarkers: Output<List<String>>? = null,
    public val baseUrlContent: Output<String>? = null,
    public val baseUrlContent1: Output<String>? = null,
    public val baseUrlManifest: Output<String>? = null,
    public val baseUrlManifest1: Output<String>? = null,
    public val captionLanguageMappings: Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>>? =
        null,
    public val captionLanguageSetting: Output<String>? = null,
    public val clientCache: Output<String>? = null,
    public val codecSpecification: Output<String>? = null,
    public val constantIv: Output<String>? = null,
    public val destination: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgs>,
    public val directoryStructure: Output<String>? = null,
    public val discontinuityTags: Output<String>? = null,
    public val encryptionType: Output<String>? = null,
    public val hlsCdnSettings: Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>>? =
        null,
    public val hlsId3SegmentTagging: Output<String>? = null,
    public val iframeOnlyPlaylists: Output<String>? = null,
    public val incompleteSegmentBehavior: Output<String>? = null,
    public val indexNSegments: Output<Int>? = null,
    public val inputLossAction: Output<String>? = null,
    public val ivInManifest: Output<String>? = null,
    public val ivSource: Output<String>? = null,
    public val keepSegments: Output<Int>? = null,
    public val keyFormat: Output<String>? = null,
    public val keyFormatVersions: Output<String>? = null,
    public val keyProviderSettings: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgs>? =
        null,
    public val manifestCompression: Output<String>? = null,
    public val manifestDurationFormat: Output<String>? = null,
    public val minSegmentLength: Output<Int>? = null,
    public val mode: Output<String>? = null,
    public val outputSelection: Output<String>? = null,
    public val programDateTime: Output<String>? = null,
    public val programDateTimeClock: Output<String>? = null,
    public val programDateTimePeriod: Output<Int>? = null,
    public val redundantManifest: Output<String>? = null,
    public val segmentLength: Output<Int>? = null,
    public val segmentsPerSubdirectory: Output<Int>? = null,
    public val streamInfResolution: Output<String>? = null,
    public val timedMetadataId3Frame: Output<String>? = null,
    public val timedMetadataId3Period: Output<Int>? = null,
    public val timestampDeltaMilliseconds: Output<Int>? = null,
    public val tsFileMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs.builder()
            .adMarkers(adMarkers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .baseUrlContent(baseUrlContent?.applyValue({ args0 -> args0 }))
            .baseUrlContent1(baseUrlContent1?.applyValue({ args0 -> args0 }))
            .baseUrlManifest(baseUrlManifest?.applyValue({ args0 -> args0 }))
            .baseUrlManifest1(baseUrlManifest1?.applyValue({ args0 -> args0 }))
            .captionLanguageMappings(
                captionLanguageMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .captionLanguageSetting(captionLanguageSetting?.applyValue({ args0 -> args0 }))
            .clientCache(clientCache?.applyValue({ args0 -> args0 }))
            .codecSpecification(codecSpecification?.applyValue({ args0 -> args0 }))
            .constantIv(constantIv?.applyValue({ args0 -> args0 }))
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .directoryStructure(directoryStructure?.applyValue({ args0 -> args0 }))
            .discontinuityTags(discontinuityTags?.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .hlsCdnSettings(
                hlsCdnSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hlsId3SegmentTagging(hlsId3SegmentTagging?.applyValue({ args0 -> args0 }))
            .iframeOnlyPlaylists(iframeOnlyPlaylists?.applyValue({ args0 -> args0 }))
            .incompleteSegmentBehavior(incompleteSegmentBehavior?.applyValue({ args0 -> args0 }))
            .indexNSegments(indexNSegments?.applyValue({ args0 -> args0 }))
            .inputLossAction(inputLossAction?.applyValue({ args0 -> args0 }))
            .ivInManifest(ivInManifest?.applyValue({ args0 -> args0 }))
            .ivSource(ivSource?.applyValue({ args0 -> args0 }))
            .keepSegments(keepSegments?.applyValue({ args0 -> args0 }))
            .keyFormat(keyFormat?.applyValue({ args0 -> args0 }))
            .keyFormatVersions(keyFormatVersions?.applyValue({ args0 -> args0 }))
            .keyProviderSettings(
                keyProviderSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .manifestCompression(manifestCompression?.applyValue({ args0 -> args0 }))
            .manifestDurationFormat(manifestDurationFormat?.applyValue({ args0 -> args0 }))
            .minSegmentLength(minSegmentLength?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .outputSelection(outputSelection?.applyValue({ args0 -> args0 }))
            .programDateTime(programDateTime?.applyValue({ args0 -> args0 }))
            .programDateTimeClock(programDateTimeClock?.applyValue({ args0 -> args0 }))
            .programDateTimePeriod(programDateTimePeriod?.applyValue({ args0 -> args0 }))
            .redundantManifest(redundantManifest?.applyValue({ args0 -> args0 }))
            .segmentLength(segmentLength?.applyValue({ args0 -> args0 }))
            .segmentsPerSubdirectory(segmentsPerSubdirectory?.applyValue({ args0 -> args0 }))
            .streamInfResolution(streamInfResolution?.applyValue({ args0 -> args0 }))
            .timedMetadataId3Frame(timedMetadataId3Frame?.applyValue({ args0 -> args0 }))
            .timedMetadataId3Period(timedMetadataId3Period?.applyValue({ args0 -> args0 }))
            .timestampDeltaMilliseconds(timestampDeltaMilliseconds?.applyValue({ args0 -> args0 }))
            .tsFileMode(tsFileMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgsBuilder
internal constructor() {
    private var adMarkers: Output<List<String>>? = null

    private var baseUrlContent: Output<String>? = null

    private var baseUrlContent1: Output<String>? = null

    private var baseUrlManifest: Output<String>? = null

    private var baseUrlManifest1: Output<String>? = null

    private var captionLanguageMappings:
        Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>>? =
        null

    private var captionLanguageSetting: Output<String>? = null

    private var clientCache: Output<String>? = null

    private var codecSpecification: Output<String>? = null

    private var constantIv: Output<String>? = null

    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgs>? =
        null

    private var directoryStructure: Output<String>? = null

    private var discontinuityTags: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var hlsCdnSettings:
        Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>>? =
        null

    private var hlsId3SegmentTagging: Output<String>? = null

    private var iframeOnlyPlaylists: Output<String>? = null

    private var incompleteSegmentBehavior: Output<String>? = null

    private var indexNSegments: Output<Int>? = null

    private var inputLossAction: Output<String>? = null

    private var ivInManifest: Output<String>? = null

    private var ivSource: Output<String>? = null

    private var keepSegments: Output<Int>? = null

    private var keyFormat: Output<String>? = null

    private var keyFormatVersions: Output<String>? = null

    private var keyProviderSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgs>? =
        null

    private var manifestCompression: Output<String>? = null

    private var manifestDurationFormat: Output<String>? = null

    private var minSegmentLength: Output<Int>? = null

    private var mode: Output<String>? = null

    private var outputSelection: Output<String>? = null

    private var programDateTime: Output<String>? = null

    private var programDateTimeClock: Output<String>? = null

    private var programDateTimePeriod: Output<Int>? = null

    private var redundantManifest: Output<String>? = null

    private var segmentLength: Output<Int>? = null

    private var segmentsPerSubdirectory: Output<Int>? = null

    private var streamInfResolution: Output<String>? = null

    private var timedMetadataId3Frame: Output<String>? = null

    private var timedMetadataId3Period: Output<Int>? = null

    private var timestampDeltaMilliseconds: Output<Int>? = null

    private var tsFileMode: Output<String>? = null

    /**
     * @param value The ad marker type for this output group.
     */
    @JvmName("ncxpthcisyovlqvi")
    public suspend fun adMarkers(`value`: Output<List<String>>) {
        this.adMarkers = value
    }

    @JvmName("irfrpbgbsexfdooi")
    public suspend fun adMarkers(vararg values: Output<String>) {
        this.adMarkers = Output.all(values.asList())
    }

    /**
     * @param values The ad marker type for this output group.
     */
    @JvmName("cjsjipbssjjerawu")
    public suspend fun adMarkers(values: List<Output<String>>) {
        this.adMarkers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fxyslvnhseqcbbhj")
    public suspend fun baseUrlContent(`value`: Output<String>) {
        this.baseUrlContent = value
    }

    /**
     * @param value
     */
    @JvmName("glyhxbcbgpegyoea")
    public suspend fun baseUrlContent1(`value`: Output<String>) {
        this.baseUrlContent1 = value
    }

    /**
     * @param value
     */
    @JvmName("tayspovlvtkaehwi")
    public suspend fun baseUrlManifest(`value`: Output<String>) {
        this.baseUrlManifest = value
    }

    /**
     * @param value
     */
    @JvmName("mgbmhjxksrnqfhhi")
    public suspend fun baseUrlManifest1(`value`: Output<String>) {
        this.baseUrlManifest1 = value
    }

    /**
     * @param value
     */
    @JvmName("bxuhwqpydmjxxfbx")
    public suspend fun captionLanguageMappings(`value`: Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>>) {
        this.captionLanguageMappings = value
    }

    @JvmName("rydnhosoavbbdqej")
    public suspend fun captionLanguageMappings(vararg values: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>) {
        this.captionLanguageMappings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tafqkvehlrfhgbfs")
    public suspend fun captionLanguageMappings(values: List<Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>>) {
        this.captionLanguageMappings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kpvdtdowkcqbikiv")
    public suspend fun captionLanguageSetting(`value`: Output<String>) {
        this.captionLanguageSetting = value
    }

    /**
     * @param value
     */
    @JvmName("tdpqctfegcbmtuwx")
    public suspend fun clientCache(`value`: Output<String>) {
        this.clientCache = value
    }

    /**
     * @param value
     */
    @JvmName("gusfyccaaampsavs")
    public suspend fun codecSpecification(`value`: Output<String>) {
        this.codecSpecification = value
    }

    /**
     * @param value
     */
    @JvmName("oxmvuoiolhtidrbq")
    public suspend fun constantIv(`value`: Output<String>) {
        this.constantIv = value
    }

    /**
     * @param value
     */
    @JvmName("pdeecorkqbbwftty")
    public suspend fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("telavtriyqrlasog")
    public suspend fun directoryStructure(`value`: Output<String>) {
        this.directoryStructure = value
    }

    /**
     * @param value
     */
    @JvmName("whmrkgehynkrvqga")
    public suspend fun discontinuityTags(`value`: Output<String>) {
        this.discontinuityTags = value
    }

    /**
     * @param value
     */
    @JvmName("bwgcpuspwvkckjos")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value
     */
    @JvmName("kpocykxmdnisljsb")
    public suspend fun hlsCdnSettings(`value`: Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>>) {
        this.hlsCdnSettings = value
    }

    @JvmName("qhnewmxuuubnxkws")
    public suspend fun hlsCdnSettings(vararg values: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>) {
        this.hlsCdnSettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yojfplvghnunhdjq")
    public suspend fun hlsCdnSettings(values: List<Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>>) {
        this.hlsCdnSettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qyybndlilruubwmm")
    public suspend fun hlsId3SegmentTagging(`value`: Output<String>) {
        this.hlsId3SegmentTagging = value
    }

    /**
     * @param value
     */
    @JvmName("yxjgeyshqupaiokl")
    public suspend fun iframeOnlyPlaylists(`value`: Output<String>) {
        this.iframeOnlyPlaylists = value
    }

    /**
     * @param value
     */
    @JvmName("kvvrevmvopudrtfj")
    public suspend fun incompleteSegmentBehavior(`value`: Output<String>) {
        this.incompleteSegmentBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("lchelfflbfpjplxb")
    public suspend fun indexNSegments(`value`: Output<Int>) {
        this.indexNSegments = value
    }

    /**
     * @param value
     */
    @JvmName("nhpboskiwgppbxle")
    public suspend fun inputLossAction(`value`: Output<String>) {
        this.inputLossAction = value
    }

    /**
     * @param value
     */
    @JvmName("jxwvxjwtfgmyxbdh")
    public suspend fun ivInManifest(`value`: Output<String>) {
        this.ivInManifest = value
    }

    /**
     * @param value
     */
    @JvmName("jatxsiukdjsujsta")
    public suspend fun ivSource(`value`: Output<String>) {
        this.ivSource = value
    }

    /**
     * @param value
     */
    @JvmName("dvlwyupjgfiyeift")
    public suspend fun keepSegments(`value`: Output<Int>) {
        this.keepSegments = value
    }

    /**
     * @param value
     */
    @JvmName("brnmphuaajyoigsx")
    public suspend fun keyFormat(`value`: Output<String>) {
        this.keyFormat = value
    }

    /**
     * @param value
     */
    @JvmName("mavupqsdhjaqstky")
    public suspend fun keyFormatVersions(`value`: Output<String>) {
        this.keyFormatVersions = value
    }

    /**
     * @param value
     */
    @JvmName("kojusmejjvckgdll")
    public suspend fun keyProviderSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgs>) {
        this.keyProviderSettings = value
    }

    /**
     * @param value
     */
    @JvmName("fnvsgxutnqpspmxp")
    public suspend fun manifestCompression(`value`: Output<String>) {
        this.manifestCompression = value
    }

    /**
     * @param value
     */
    @JvmName("rxelpyfmcjkkeelo")
    public suspend fun manifestDurationFormat(`value`: Output<String>) {
        this.manifestDurationFormat = value
    }

    /**
     * @param value
     */
    @JvmName("fxddvmpbvhafveoe")
    public suspend fun minSegmentLength(`value`: Output<Int>) {
        this.minSegmentLength = value
    }

    /**
     * @param value
     */
    @JvmName("lnwadbmvohdvmyjd")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value
     */
    @JvmName("uwslbmbodycewfuy")
    public suspend fun outputSelection(`value`: Output<String>) {
        this.outputSelection = value
    }

    /**
     * @param value
     */
    @JvmName("otpwcitgllruaalh")
    public suspend fun programDateTime(`value`: Output<String>) {
        this.programDateTime = value
    }

    /**
     * @param value
     */
    @JvmName("tylbdyjyuofylwyy")
    public suspend fun programDateTimeClock(`value`: Output<String>) {
        this.programDateTimeClock = value
    }

    /**
     * @param value
     */
    @JvmName("tmvvmvpteqivxtxl")
    public suspend fun programDateTimePeriod(`value`: Output<Int>) {
        this.programDateTimePeriod = value
    }

    /**
     * @param value
     */
    @JvmName("uaegygccsasmcbrx")
    public suspend fun redundantManifest(`value`: Output<String>) {
        this.redundantManifest = value
    }

    /**
     * @param value
     */
    @JvmName("vleoaemvdlsammiw")
    public suspend fun segmentLength(`value`: Output<Int>) {
        this.segmentLength = value
    }

    /**
     * @param value
     */
    @JvmName("tcvvgsprxyuilodr")
    public suspend fun segmentsPerSubdirectory(`value`: Output<Int>) {
        this.segmentsPerSubdirectory = value
    }

    /**
     * @param value
     */
    @JvmName("gfudcabgqetbhsxi")
    public suspend fun streamInfResolution(`value`: Output<String>) {
        this.streamInfResolution = value
    }

    /**
     * @param value Indicates ID3 frame that has the timecode.
     */
    @JvmName("enwsdsrumbwkcnqr")
    public suspend fun timedMetadataId3Frame(`value`: Output<String>) {
        this.timedMetadataId3Frame = value
    }

    /**
     * @param value
     */
    @JvmName("qrfgtultjnokiois")
    public suspend fun timedMetadataId3Period(`value`: Output<Int>) {
        this.timedMetadataId3Period = value
    }

    /**
     * @param value
     */
    @JvmName("owtysbtuaebcmfqn")
    public suspend fun timestampDeltaMilliseconds(`value`: Output<Int>) {
        this.timestampDeltaMilliseconds = value
    }

    /**
     * @param value
     */
    @JvmName("algujntuubpyjucs")
    public suspend fun tsFileMode(`value`: Output<String>) {
        this.tsFileMode = value
    }

    /**
     * @param value The ad marker type for this output group.
     */
    @JvmName("vlojsdxnsnxjawtx")
    public suspend fun adMarkers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adMarkers = mapped
    }

    /**
     * @param values The ad marker type for this output group.
     */
    @JvmName("phfregkomyarxbdh")
    public suspend fun adMarkers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adMarkers = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghdpsviuprcddidm")
    public suspend fun baseUrlContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseUrlContent = mapped
    }

    /**
     * @param value
     */
    @JvmName("wagxogrptkmnnxjs")
    public suspend fun baseUrlContent1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseUrlContent1 = mapped
    }

    /**
     * @param value
     */
    @JvmName("jnwtwskvllrgqyjy")
    public suspend fun baseUrlManifest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseUrlManifest = mapped
    }

    /**
     * @param value
     */
    @JvmName("mvqabvxhurdbglyt")
    public suspend fun baseUrlManifest1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseUrlManifest1 = mapped
    }

    /**
     * @param value
     */
    @JvmName("hagvnsytutjwdoxv")
    public suspend fun captionLanguageMappings(`value`: List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionLanguageMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jqvdouueejpgqsio")
    public suspend fun captionLanguageMappings(argument: List<suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.captionLanguageMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("htibvgumnhaqmtfl")
    public suspend fun captionLanguageMappings(vararg argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.captionLanguageMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dsbsdnhugjvfcffm")
    public suspend fun captionLanguageMappings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.captionLanguageMappings = mapped
    }

    /**
     * @param values
     */
    @JvmName("xniphhdorcmuffgb")
    public suspend fun captionLanguageMappings(vararg values: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionLanguageMappings = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfyxmkwcgkmxxoei")
    public suspend fun captionLanguageSetting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionLanguageSetting = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihiacycagdcdfvji")
    public suspend fun clientCache(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCache = mapped
    }

    /**
     * @param value
     */
    @JvmName("cnwndcqqvprcilif")
    public suspend fun codecSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecSpecification = mapped
    }

    /**
     * @param value
     */
    @JvmName("updtkfhnwcakcebm")
    public suspend fun constantIv(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constantIv = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihulusoorfbcxtpk")
    public suspend fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kuxwsxxmvnpqydoy")
    public suspend fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("kggxebkbyrwcxjab")
    public suspend fun directoryStructure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryStructure = mapped
    }

    /**
     * @param value
     */
    @JvmName("pymrwkusqieidimg")
    public suspend fun discontinuityTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discontinuityTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("qgtmbjrqborfycaa")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value
     */
    @JvmName("pwgakmffuffmxhyc")
    public suspend fun hlsCdnSettings(`value`: List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsCdnSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("monhdqcxqgbopyww")
    public suspend fun hlsCdnSettings(argument: List<suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hlsCdnSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("apobxvpmpdmkqsel")
    public suspend fun hlsCdnSettings(vararg argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hlsCdnSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yhtbfdwficucnutv")
    public suspend fun hlsCdnSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.hlsCdnSettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("mwkrdsssmhkhsofg")
    public suspend fun hlsCdnSettings(vararg values: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hlsCdnSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("urkpoabbescswfhp")
    public suspend fun hlsId3SegmentTagging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsId3SegmentTagging = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwxeoesmhqnlmdje")
    public suspend fun iframeOnlyPlaylists(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iframeOnlyPlaylists = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibautrbuuujcgdnr")
    public suspend fun incompleteSegmentBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incompleteSegmentBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("grnwigfwrhhprggj")
    public suspend fun indexNSegments(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexNSegments = mapped
    }

    /**
     * @param value
     */
    @JvmName("socwkytbjjxodjvc")
    public suspend fun inputLossAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossAction = mapped
    }

    /**
     * @param value
     */
    @JvmName("xcdpmntfqkjmacrt")
    public suspend fun ivInManifest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ivInManifest = mapped
    }

    /**
     * @param value
     */
    @JvmName("njnpotdxcndaguvs")
    public suspend fun ivSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ivSource = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmlmvfeulufdcopr")
    public suspend fun keepSegments(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepSegments = mapped
    }

    /**
     * @param value
     */
    @JvmName("ckanvuhgykuyfmjx")
    public suspend fun keyFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("peigckpswdtvpsdm")
    public suspend fun keyFormatVersions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFormatVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("njklwxwgddexgmlb")
    public suspend fun keyProviderSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyProviderSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ltrgkicbwxtdskrk")
    public suspend fun keyProviderSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.keyProviderSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjkvuykahwibhhom")
    public suspend fun manifestCompression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestCompression = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcwuwxyhhwmqjuob")
    public suspend fun manifestDurationFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestDurationFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("jvbcawcimuvqadyn")
    public suspend fun minSegmentLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSegmentLength = mapped
    }

    /**
     * @param value
     */
    @JvmName("otccrlpplxcpottt")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value
     */
    @JvmName("dysnvvcdggjqtrbr")
    public suspend fun outputSelection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputSelection = mapped
    }

    /**
     * @param value
     */
    @JvmName("mawqvyaylemyynhd")
    public suspend fun programDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programDateTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("odycqlhhwyfbeqyv")
    public suspend fun programDateTimeClock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programDateTimeClock = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvgfhcvjtkemshau")
    public suspend fun programDateTimePeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programDateTimePeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("xhpkfvypogddhmiq")
    public suspend fun redundantManifest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redundantManifest = mapped
    }

    /**
     * @param value
     */
    @JvmName("cfxvlbpmejpagrhg")
    public suspend fun segmentLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentLength = mapped
    }

    /**
     * @param value
     */
    @JvmName("mvdsknkuisywcttu")
    public suspend fun segmentsPerSubdirectory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentsPerSubdirectory = mapped
    }

    /**
     * @param value
     */
    @JvmName("wdhfeucnbiiasnvd")
    public suspend fun streamInfResolution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamInfResolution = mapped
    }

    /**
     * @param value Indicates ID3 frame that has the timecode.
     */
    @JvmName("rvekdupuagsnodel")
    public suspend fun timedMetadataId3Frame(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataId3Frame = mapped
    }

    /**
     * @param value
     */
    @JvmName("krfbrbmqgmwhsfur")
    public suspend fun timedMetadataId3Period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataId3Period = mapped
    }

    /**
     * @param value
     */
    @JvmName("exuxfrkommhilldv")
    public suspend fun timestampDeltaMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampDeltaMilliseconds = mapped
    }

    /**
     * @param value
     */
    @JvmName("vdrixwtdtkdntbwj")
    public suspend fun tsFileMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tsFileMode = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs(
            adMarkers = adMarkers,
            baseUrlContent = baseUrlContent,
            baseUrlContent1 = baseUrlContent1,
            baseUrlManifest = baseUrlManifest,
            baseUrlManifest1 = baseUrlManifest1,
            captionLanguageMappings = captionLanguageMappings,
            captionLanguageSetting = captionLanguageSetting,
            clientCache = clientCache,
            codecSpecification = codecSpecification,
            constantIv = constantIv,
            destination = destination ?: throw PulumiNullFieldException("destination"),
            directoryStructure = directoryStructure,
            discontinuityTags = discontinuityTags,
            encryptionType = encryptionType,
            hlsCdnSettings = hlsCdnSettings,
            hlsId3SegmentTagging = hlsId3SegmentTagging,
            iframeOnlyPlaylists = iframeOnlyPlaylists,
            incompleteSegmentBehavior = incompleteSegmentBehavior,
            indexNSegments = indexNSegments,
            inputLossAction = inputLossAction,
            ivInManifest = ivInManifest,
            ivSource = ivSource,
            keepSegments = keepSegments,
            keyFormat = keyFormat,
            keyFormatVersions = keyFormatVersions,
            keyProviderSettings = keyProviderSettings,
            manifestCompression = manifestCompression,
            manifestDurationFormat = manifestDurationFormat,
            minSegmentLength = minSegmentLength,
            mode = mode,
            outputSelection = outputSelection,
            programDateTime = programDateTime,
            programDateTimeClock = programDateTimeClock,
            programDateTimePeriod = programDateTimePeriod,
            redundantManifest = redundantManifest,
            segmentLength = segmentLength,
            segmentsPerSubdirectory = segmentsPerSubdirectory,
            streamInfResolution = streamInfResolution,
            timedMetadataId3Frame = timedMetadataId3Frame,
            timedMetadataId3Period = timedMetadataId3Period,
            timestampDeltaMilliseconds = timestampDeltaMilliseconds,
            tsFileMode = tsFileMode,
        )
}
