@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property captionChannel
 * @property languageCode
 * @property languageDescription Human readable information to indicate captions available for players (eg. English, or Spanish).
 */
public data class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs(
    public val captionChannel: Output<Int>,
    public val languageCode: Output<String>,
    public val languageDescription: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs.builder()
            .captionChannel(captionChannel.applyValue({ args0 -> args0 }))
            .languageCode(languageCode.applyValue({ args0 -> args0 }))
            .languageDescription(languageDescription.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgsBuilder
internal constructor() {
    private var captionChannel: Output<Int>? = null

    private var languageCode: Output<String>? = null

    private var languageDescription: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("evkyiokkwgedmsus")
    public suspend fun captionChannel(`value`: Output<Int>) {
        this.captionChannel = value
    }

    /**
     * @param value
     */
    @JvmName("ctbexciabilggdds")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    @JvmName("pivuwuobbcolfwyv")
    public suspend fun languageDescription(`value`: Output<String>) {
        this.languageDescription = value
    }

    /**
     * @param value
     */
    @JvmName("yxvcjqgqodexfpyl")
    public suspend fun captionChannel(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionChannel = mapped
    }

    /**
     * @param value
     */
    @JvmName("ycltdvyuojucbska")
    public suspend fun languageCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    @JvmName("vhtdmkfthoererln")
    public suspend fun languageDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageDescription = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsCaptionLanguageMappingArgs(
            captionChannel = captionChannel ?: throw PulumiNullFieldException("captionChannel"),
            languageCode = languageCode ?: throw PulumiNullFieldException("languageCode"),
            languageDescription = languageDescription ?: throw PulumiNullFieldException("languageDescription"),
        )
}
