@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property filecacheDuration
 * @property numRetries Number of retry attempts.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 */
public data class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs(
    public val connectionRetryInterval: Output<Int>? = null,
    public val filecacheDuration: Output<Int>? = null,
    public val numRetries: Output<Int>? = null,
    public val restartDelay: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs.builder()
            .connectionRetryInterval(connectionRetryInterval?.applyValue({ args0 -> args0 }))
            .filecacheDuration(filecacheDuration?.applyValue({ args0 -> args0 }))
            .numRetries(numRetries?.applyValue({ args0 -> args0 }))
            .restartDelay(restartDelay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgsBuilder
internal constructor() {
    private var connectionRetryInterval: Output<Int>? = null

    private var filecacheDuration: Output<Int>? = null

    private var numRetries: Output<Int>? = null

    private var restartDelay: Output<Int>? = null

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("tpdkmvwjbmdsiype")
    public suspend fun connectionRetryInterval(`value`: Output<Int>) {
        this.connectionRetryInterval = value
    }

    /**
     * @param value
     */
    @JvmName("yoygbvxdxfsfayfb")
    public suspend fun filecacheDuration(`value`: Output<Int>) {
        this.filecacheDuration = value
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("diljwjvhldlbtawc")
    public suspend fun numRetries(`value`: Output<Int>) {
        this.numRetries = value
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("lthbihjbrwlmceqs")
    public suspend fun restartDelay(`value`: Output<Int>) {
        this.restartDelay = value
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("lmvgendvghnjgmny")
    public suspend fun connectionRetryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionRetryInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("jgasecxpdqmfqbci")
    public suspend fun filecacheDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filecacheDuration = mapped
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("olxmgtgiligpogpt")
    public suspend fun numRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRetries = mapped
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("rugvfnndrutpueif")
    public suspend fun restartDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartDelay = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsBasicPutSettingsArgs(
            connectionRetryInterval = connectionRetryInterval,
            filecacheDuration = filecacheDuration,
            numRetries = numRetries,
            restartDelay = restartDelay,
        )
}
