@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acquisitionPointId
 * @property audioOnlyTimecodeControl
 * @property certificateMode Setting to allow self signed or verified RTMP certificates.
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property destination
 * @property eventId
 * @property eventIdMode
 * @property eventStopBehavior
 * @property filecacheDuration
 * @property fragmentLength
 * @property inputLossAction
 * @property numRetries Number of retry attempts.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 * @property segmentationMode
 * @property sendDelayMs
 * @property sparseTrackType
 * @property streamManifestBehavior
 * @property timestampOffset
 * @property timestampOffsetMode
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs(
    public val acquisitionPointId: Output<String>? = null,
    public val audioOnlyTimecodeControl: Output<String>? = null,
    public val certificateMode: Output<String>? = null,
    public val connectionRetryInterval: Output<Int>? = null,
    public val destination: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgs>,
    public val eventId: Output<String>? = null,
    public val eventIdMode: Output<String>? = null,
    public val eventStopBehavior: Output<String>? = null,
    public val filecacheDuration: Output<Int>? = null,
    public val fragmentLength: Output<Int>? = null,
    public val inputLossAction: Output<String>? = null,
    public val numRetries: Output<Int>? = null,
    public val restartDelay: Output<Int>? = null,
    public val segmentationMode: Output<String>? = null,
    public val sendDelayMs: Output<Int>? = null,
    public val sparseTrackType: Output<String>? = null,
    public val streamManifestBehavior: Output<String>? = null,
    public val timestampOffset: Output<String>? = null,
    public val timestampOffsetMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs.builder()
            .acquisitionPointId(acquisitionPointId?.applyValue({ args0 -> args0 }))
            .audioOnlyTimecodeControl(audioOnlyTimecodeControl?.applyValue({ args0 -> args0 }))
            .certificateMode(certificateMode?.applyValue({ args0 -> args0 }))
            .connectionRetryInterval(connectionRetryInterval?.applyValue({ args0 -> args0 }))
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventId(eventId?.applyValue({ args0 -> args0 }))
            .eventIdMode(eventIdMode?.applyValue({ args0 -> args0 }))
            .eventStopBehavior(eventStopBehavior?.applyValue({ args0 -> args0 }))
            .filecacheDuration(filecacheDuration?.applyValue({ args0 -> args0 }))
            .fragmentLength(fragmentLength?.applyValue({ args0 -> args0 }))
            .inputLossAction(inputLossAction?.applyValue({ args0 -> args0 }))
            .numRetries(numRetries?.applyValue({ args0 -> args0 }))
            .restartDelay(restartDelay?.applyValue({ args0 -> args0 }))
            .segmentationMode(segmentationMode?.applyValue({ args0 -> args0 }))
            .sendDelayMs(sendDelayMs?.applyValue({ args0 -> args0 }))
            .sparseTrackType(sparseTrackType?.applyValue({ args0 -> args0 }))
            .streamManifestBehavior(streamManifestBehavior?.applyValue({ args0 -> args0 }))
            .timestampOffset(timestampOffset?.applyValue({ args0 -> args0 }))
            .timestampOffsetMode(timestampOffsetMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgsBuilder
internal constructor() {
    private var acquisitionPointId: Output<String>? = null

    private var audioOnlyTimecodeControl: Output<String>? = null

    private var certificateMode: Output<String>? = null

    private var connectionRetryInterval: Output<Int>? = null

    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgs>? =
        null

    private var eventId: Output<String>? = null

    private var eventIdMode: Output<String>? = null

    private var eventStopBehavior: Output<String>? = null

    private var filecacheDuration: Output<Int>? = null

    private var fragmentLength: Output<Int>? = null

    private var inputLossAction: Output<String>? = null

    private var numRetries: Output<Int>? = null

    private var restartDelay: Output<Int>? = null

    private var segmentationMode: Output<String>? = null

    private var sendDelayMs: Output<Int>? = null

    private var sparseTrackType: Output<String>? = null

    private var streamManifestBehavior: Output<String>? = null

    private var timestampOffset: Output<String>? = null

    private var timestampOffsetMode: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("djdhjhqptmtxxicm")
    public suspend fun acquisitionPointId(`value`: Output<String>) {
        this.acquisitionPointId = value
    }

    /**
     * @param value
     */
    @JvmName("iesiypqdsjtxnjlx")
    public suspend fun audioOnlyTimecodeControl(`value`: Output<String>) {
        this.audioOnlyTimecodeControl = value
    }

    /**
     * @param value Setting to allow self signed or verified RTMP certificates.
     */
    @JvmName("mhbswanxjcyrdiqn")
    public suspend fun certificateMode(`value`: Output<String>) {
        this.certificateMode = value
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("oiuhejxqwsissnnq")
    public suspend fun connectionRetryInterval(`value`: Output<Int>) {
        this.connectionRetryInterval = value
    }

    /**
     * @param value
     */
    @JvmName("pijvwrntcsbuwqrt")
    public suspend fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("cbbbtrgbsckgsilo")
    public suspend fun eventId(`value`: Output<String>) {
        this.eventId = value
    }

    /**
     * @param value
     */
    @JvmName("lwbfwtytbodrcsro")
    public suspend fun eventIdMode(`value`: Output<String>) {
        this.eventIdMode = value
    }

    /**
     * @param value
     */
    @JvmName("ycwnsounropbxyty")
    public suspend fun eventStopBehavior(`value`: Output<String>) {
        this.eventStopBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("isawrsxonbdkdupe")
    public suspend fun filecacheDuration(`value`: Output<Int>) {
        this.filecacheDuration = value
    }

    /**
     * @param value
     */
    @JvmName("uijicvqnobxunxir")
    public suspend fun fragmentLength(`value`: Output<Int>) {
        this.fragmentLength = value
    }

    /**
     * @param value
     */
    @JvmName("sxyrekhxwqvnwjjp")
    public suspend fun inputLossAction(`value`: Output<String>) {
        this.inputLossAction = value
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("tobdcxihxxhyckea")
    public suspend fun numRetries(`value`: Output<Int>) {
        this.numRetries = value
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("jkosydpkuqysiexp")
    public suspend fun restartDelay(`value`: Output<Int>) {
        this.restartDelay = value
    }

    /**
     * @param value
     */
    @JvmName("pxlakucpyonnlslv")
    public suspend fun segmentationMode(`value`: Output<String>) {
        this.segmentationMode = value
    }

    /**
     * @param value
     */
    @JvmName("npchvahlrsvkgvvt")
    public suspend fun sendDelayMs(`value`: Output<Int>) {
        this.sendDelayMs = value
    }

    /**
     * @param value
     */
    @JvmName("andiivceroxlfofd")
    public suspend fun sparseTrackType(`value`: Output<String>) {
        this.sparseTrackType = value
    }

    /**
     * @param value
     */
    @JvmName("uhpbxtkixcmmlxph")
    public suspend fun streamManifestBehavior(`value`: Output<String>) {
        this.streamManifestBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("rilqgglbosbvmpgm")
    public suspend fun timestampOffset(`value`: Output<String>) {
        this.timestampOffset = value
    }

    /**
     * @param value
     */
    @JvmName("voaencrllfanodll")
    public suspend fun timestampOffsetMode(`value`: Output<String>) {
        this.timestampOffsetMode = value
    }

    /**
     * @param value
     */
    @JvmName("filsubekdsrksfyh")
    public suspend fun acquisitionPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acquisitionPointId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbgjwisuaougtytb")
    public suspend fun audioOnlyTimecodeControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioOnlyTimecodeControl = mapped
    }

    /**
     * @param value Setting to allow self signed or verified RTMP certificates.
     */
    @JvmName("gsjfqkkrvxrmbaed")
    public suspend fun certificateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateMode = mapped
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("owyhonstghpjwdby")
    public suspend fun connectionRetryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionRetryInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("tmcuytbbruhfwlkk")
    public suspend fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument
     */
    @JvmName("frnexnangnmqumvh")
    public suspend fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("mxxnguqxhrbsywjy")
    public suspend fun eventId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventId = mapped
    }

    /**
     * @param value
     */
    @JvmName("smosdudmtfsflsyu")
    public suspend fun eventIdMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventIdMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("wkvdsdciovpfmrxv")
    public suspend fun eventStopBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventStopBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("kflujfoxgutyjguv")
    public suspend fun filecacheDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filecacheDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxnvxscxktymjnuj")
    public suspend fun fragmentLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fragmentLength = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptglcsxopgvlupfy")
    public suspend fun inputLossAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossAction = mapped
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("mckqprvgttmeqduc")
    public suspend fun numRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRetries = mapped
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("scfsogsduwspivap")
    public suspend fun restartDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartDelay = mapped
    }

    /**
     * @param value
     */
    @JvmName("qaduccnteyjtdtcv")
    public suspend fun segmentationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("bakpsrnhyqluloas")
    public suspend fun sendDelayMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendDelayMs = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijgkestlqsqpvdja")
    public suspend fun sparseTrackType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparseTrackType = mapped
    }

    /**
     * @param value
     */
    @JvmName("eonnkisghdqfnwym")
    public suspend fun streamManifestBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamManifestBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjyvyhnlfdubvcfa")
    public suspend fun timestampOffset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampOffset = mapped
    }

    /**
     * @param value
     */
    @JvmName("ioceopibltoytfyi")
    public suspend fun timestampOffsetMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampOffsetMode = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs(
            acquisitionPointId = acquisitionPointId,
            audioOnlyTimecodeControl = audioOnlyTimecodeControl,
            certificateMode = certificateMode,
            connectionRetryInterval = connectionRetryInterval,
            destination = destination ?: throw PulumiNullFieldException("destination"),
            eventId = eventId,
            eventIdMode = eventIdMode,
            eventStopBehavior = eventStopBehavior,
            filecacheDuration = filecacheDuration,
            fragmentLength = fragmentLength,
            inputLossAction = inputLossAction,
            numRetries = numRetries,
            restartDelay = restartDelay,
            segmentationMode = segmentationMode,
            sendDelayMs = sendDelayMs,
            sparseTrackType = sparseTrackType,
            streamManifestBehavior = streamManifestBehavior,
            timestampOffset = timestampOffset,
            timestampOffsetMode = timestampOffsetMode,
        )
}
