@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property containerSettings Settings specific to the container type of the file. See Container Settings for more details.
 * @property extension Output file extension.
 * @property nameModifier String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs(
    public val containerSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs>? =
        null,
    public val extension: Output<String>? = null,
    public val nameModifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs.builder()
            .containerSettings(containerSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extension(extension?.applyValue({ args0 -> args0 }))
            .nameModifier(nameModifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgsBuilder
internal constructor() {
    private var containerSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs>? =
        null

    private var extension: Output<String>? = null

    private var nameModifier: Output<String>? = null

    /**
     * @param value Settings specific to the container type of the file. See Container Settings for more details.
     */
    @JvmName("eisoijbrhubumxou")
    public suspend fun containerSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs>) {
        this.containerSettings = value
    }

    /**
     * @param value Output file extension.
     */
    @JvmName("svdeibwsoydajtbm")
    public suspend fun extension(`value`: Output<String>) {
        this.extension = value
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("oveleyfbhrgsklhg")
    public suspend fun nameModifier(`value`: Output<String>) {
        this.nameModifier = value
    }

    /**
     * @param value Settings specific to the container type of the file. See Container Settings for more details.
     */
    @JvmName("qmlhykwxuwslyjpb")
    public suspend fun containerSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerSettings = mapped
    }

    /**
     * @param argument Settings specific to the container type of the file. See Container Settings for more details.
     */
    @JvmName("kmqauerkcmcjhlue")
    public suspend fun containerSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.containerSettings = mapped
    }

    /**
     * @param value Output file extension.
     */
    @JvmName("jifmjwxelaivkcib")
    public suspend fun extension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extension = mapped
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("guaiwkjpcrempqkf")
    public suspend fun nameModifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameModifier = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs(
            containerSettings = containerSettings,
            extension = extension,
            nameModifier = nameModifier,
        )
}
