@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property absentInputAudioBehavior
 * @property arib
 * @property aribCaptionsPid
 * @property aribCaptionsPidControl
 * @property audioBufferModel
 * @property audioFramesPerPes
 * @property audioPids
 * @property audioStreamType
 * @property bitrate
 * @property bufferModel
 * @property ccDescriptor
 * @property dvbNitSettings
 * @property dvbSdtSettings
 * @property dvbSubPids
 * @property dvbTdtSettings
 * @property dvbTeletextPid
 * @property ebif
 * @property ebpAudioInterval
 * @property ebpLookaheadMs
 * @property ebpPlacement
 * @property ecmPid
 * @property esRateInPes
 * @property etvPlatformPid
 * @property etvSignalPid
 * @property fragmentTime
 * @property klv
 * @property klvDataPids
 * @property nielsenId3Behavior
 * @property nullPacketBitrate
 * @property patInterval
 * @property pcrControl
 * @property pcrPeriod
 * @property pcrPid
 * @property pmtInterval
 * @property pmtPid
 * @property programNum
 * @property rateMode
 * @property scte27Pids
 * @property scte35Control
 * @property scte35Pid PID from which to read SCTE-35 messages.
 * @property segmentationMarkers
 * @property segmentationStyle
 * @property segmentationTime
 * @property timedMetadataBehavior
 * @property timedMetadataPid
 * @property transportStreamId
 * @property videoPid
 */
public data class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs(
    public val absentInputAudioBehavior: Output<String>? = null,
    public val arib: Output<String>? = null,
    public val aribCaptionsPid: Output<String>? = null,
    public val aribCaptionsPidControl: Output<String>? = null,
    public val audioBufferModel: Output<String>? = null,
    public val audioFramesPerPes: Output<Int>? = null,
    public val audioPids: Output<String>? = null,
    public val audioStreamType: Output<String>? = null,
    public val bitrate: Output<Int>? = null,
    public val bufferModel: Output<String>? = null,
    public val ccDescriptor: Output<String>? = null,
    public val dvbNitSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>? =
        null,
    public val dvbSdtSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>? =
        null,
    public val dvbSubPids: Output<String>? = null,
    public val dvbTdtSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>? =
        null,
    public val dvbTeletextPid: Output<String>? = null,
    public val ebif: Output<String>? = null,
    public val ebpAudioInterval: Output<String>? = null,
    public val ebpLookaheadMs: Output<Int>? = null,
    public val ebpPlacement: Output<String>? = null,
    public val ecmPid: Output<String>? = null,
    public val esRateInPes: Output<String>? = null,
    public val etvPlatformPid: Output<String>? = null,
    public val etvSignalPid: Output<String>? = null,
    public val fragmentTime: Output<Double>? = null,
    public val klv: Output<String>? = null,
    public val klvDataPids: Output<String>? = null,
    public val nielsenId3Behavior: Output<String>? = null,
    public val nullPacketBitrate: Output<Double>? = null,
    public val patInterval: Output<Int>? = null,
    public val pcrControl: Output<String>? = null,
    public val pcrPeriod: Output<Int>? = null,
    public val pcrPid: Output<String>? = null,
    public val pmtInterval: Output<Int>? = null,
    public val pmtPid: Output<String>? = null,
    public val programNum: Output<Int>? = null,
    public val rateMode: Output<String>? = null,
    public val scte27Pids: Output<String>? = null,
    public val scte35Control: Output<String>? = null,
    public val scte35Pid: Output<String>? = null,
    public val segmentationMarkers: Output<String>? = null,
    public val segmentationStyle: Output<String>? = null,
    public val segmentationTime: Output<Double>? = null,
    public val timedMetadataBehavior: Output<String>? = null,
    public val timedMetadataPid: Output<String>? = null,
    public val transportStreamId: Output<Int>? = null,
    public val videoPid: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs.builder()
            .absentInputAudioBehavior(absentInputAudioBehavior?.applyValue({ args0 -> args0 }))
            .arib(arib?.applyValue({ args0 -> args0 }))
            .aribCaptionsPid(aribCaptionsPid?.applyValue({ args0 -> args0 }))
            .aribCaptionsPidControl(aribCaptionsPidControl?.applyValue({ args0 -> args0 }))
            .audioBufferModel(audioBufferModel?.applyValue({ args0 -> args0 }))
            .audioFramesPerPes(audioFramesPerPes?.applyValue({ args0 -> args0 }))
            .audioPids(audioPids?.applyValue({ args0 -> args0 }))
            .audioStreamType(audioStreamType?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bufferModel(bufferModel?.applyValue({ args0 -> args0 }))
            .ccDescriptor(ccDescriptor?.applyValue({ args0 -> args0 }))
            .dvbNitSettings(dvbNitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbSdtSettings(dvbSdtSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbSubPids(dvbSubPids?.applyValue({ args0 -> args0 }))
            .dvbTdtSettings(dvbTdtSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbTeletextPid(dvbTeletextPid?.applyValue({ args0 -> args0 }))
            .ebif(ebif?.applyValue({ args0 -> args0 }))
            .ebpAudioInterval(ebpAudioInterval?.applyValue({ args0 -> args0 }))
            .ebpLookaheadMs(ebpLookaheadMs?.applyValue({ args0 -> args0 }))
            .ebpPlacement(ebpPlacement?.applyValue({ args0 -> args0 }))
            .ecmPid(ecmPid?.applyValue({ args0 -> args0 }))
            .esRateInPes(esRateInPes?.applyValue({ args0 -> args0 }))
            .etvPlatformPid(etvPlatformPid?.applyValue({ args0 -> args0 }))
            .etvSignalPid(etvSignalPid?.applyValue({ args0 -> args0 }))
            .fragmentTime(fragmentTime?.applyValue({ args0 -> args0 }))
            .klv(klv?.applyValue({ args0 -> args0 }))
            .klvDataPids(klvDataPids?.applyValue({ args0 -> args0 }))
            .nielsenId3Behavior(nielsenId3Behavior?.applyValue({ args0 -> args0 }))
            .nullPacketBitrate(nullPacketBitrate?.applyValue({ args0 -> args0 }))
            .patInterval(patInterval?.applyValue({ args0 -> args0 }))
            .pcrControl(pcrControl?.applyValue({ args0 -> args0 }))
            .pcrPeriod(pcrPeriod?.applyValue({ args0 -> args0 }))
            .pcrPid(pcrPid?.applyValue({ args0 -> args0 }))
            .pmtInterval(pmtInterval?.applyValue({ args0 -> args0 }))
            .pmtPid(pmtPid?.applyValue({ args0 -> args0 }))
            .programNum(programNum?.applyValue({ args0 -> args0 }))
            .rateMode(rateMode?.applyValue({ args0 -> args0 }))
            .scte27Pids(scte27Pids?.applyValue({ args0 -> args0 }))
            .scte35Control(scte35Control?.applyValue({ args0 -> args0 }))
            .scte35Pid(scte35Pid?.applyValue({ args0 -> args0 }))
            .segmentationMarkers(segmentationMarkers?.applyValue({ args0 -> args0 }))
            .segmentationStyle(segmentationStyle?.applyValue({ args0 -> args0 }))
            .segmentationTime(segmentationTime?.applyValue({ args0 -> args0 }))
            .timedMetadataBehavior(timedMetadataBehavior?.applyValue({ args0 -> args0 }))
            .timedMetadataPid(timedMetadataPid?.applyValue({ args0 -> args0 }))
            .transportStreamId(transportStreamId?.applyValue({ args0 -> args0 }))
            .videoPid(videoPid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgsBuilder
internal constructor() {
    private var absentInputAudioBehavior: Output<String>? = null

    private var arib: Output<String>? = null

    private var aribCaptionsPid: Output<String>? = null

    private var aribCaptionsPidControl: Output<String>? = null

    private var audioBufferModel: Output<String>? = null

    private var audioFramesPerPes: Output<Int>? = null

    private var audioPids: Output<String>? = null

    private var audioStreamType: Output<String>? = null

    private var bitrate: Output<Int>? = null

    private var bufferModel: Output<String>? = null

    private var ccDescriptor: Output<String>? = null

    private var dvbNitSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>? =
        null

    private var dvbSdtSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>? =
        null

    private var dvbSubPids: Output<String>? = null

    private var dvbTdtSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>? =
        null

    private var dvbTeletextPid: Output<String>? = null

    private var ebif: Output<String>? = null

    private var ebpAudioInterval: Output<String>? = null

    private var ebpLookaheadMs: Output<Int>? = null

    private var ebpPlacement: Output<String>? = null

    private var ecmPid: Output<String>? = null

    private var esRateInPes: Output<String>? = null

    private var etvPlatformPid: Output<String>? = null

    private var etvSignalPid: Output<String>? = null

    private var fragmentTime: Output<Double>? = null

    private var klv: Output<String>? = null

    private var klvDataPids: Output<String>? = null

    private var nielsenId3Behavior: Output<String>? = null

    private var nullPacketBitrate: Output<Double>? = null

    private var patInterval: Output<Int>? = null

    private var pcrControl: Output<String>? = null

    private var pcrPeriod: Output<Int>? = null

    private var pcrPid: Output<String>? = null

    private var pmtInterval: Output<Int>? = null

    private var pmtPid: Output<String>? = null

    private var programNum: Output<Int>? = null

    private var rateMode: Output<String>? = null

    private var scte27Pids: Output<String>? = null

    private var scte35Control: Output<String>? = null

    private var scte35Pid: Output<String>? = null

    private var segmentationMarkers: Output<String>? = null

    private var segmentationStyle: Output<String>? = null

    private var segmentationTime: Output<Double>? = null

    private var timedMetadataBehavior: Output<String>? = null

    private var timedMetadataPid: Output<String>? = null

    private var transportStreamId: Output<Int>? = null

    private var videoPid: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("blyrdkgeysavylns")
    public suspend fun absentInputAudioBehavior(`value`: Output<String>) {
        this.absentInputAudioBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("nwdajuqjodjbocyn")
    public suspend fun arib(`value`: Output<String>) {
        this.arib = value
    }

    /**
     * @param value
     */
    @JvmName("ssiqbswquvjhuxum")
    public suspend fun aribCaptionsPid(`value`: Output<String>) {
        this.aribCaptionsPid = value
    }

    /**
     * @param value
     */
    @JvmName("hwiuuerfejgyuwfg")
    public suspend fun aribCaptionsPidControl(`value`: Output<String>) {
        this.aribCaptionsPidControl = value
    }

    /**
     * @param value
     */
    @JvmName("wivhfygeogljceqt")
    public suspend fun audioBufferModel(`value`: Output<String>) {
        this.audioBufferModel = value
    }

    /**
     * @param value
     */
    @JvmName("aqeufnnppdbwjaav")
    public suspend fun audioFramesPerPes(`value`: Output<Int>) {
        this.audioFramesPerPes = value
    }

    /**
     * @param value
     */
    @JvmName("gnfedbywmjsphbat")
    public suspend fun audioPids(`value`: Output<String>) {
        this.audioPids = value
    }

    /**
     * @param value
     */
    @JvmName("gnkvrccwlpcojrin")
    public suspend fun audioStreamType(`value`: Output<String>) {
        this.audioStreamType = value
    }

    /**
     * @param value
     */
    @JvmName("qwvddfpbbddyptot")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value
     */
    @JvmName("rlmpflxwkrfmbnmk")
    public suspend fun bufferModel(`value`: Output<String>) {
        this.bufferModel = value
    }

    /**
     * @param value
     */
    @JvmName("sjlubdlxflgljfej")
    public suspend fun ccDescriptor(`value`: Output<String>) {
        this.ccDescriptor = value
    }

    /**
     * @param value
     */
    @JvmName("hyutugsbfvjysdqo")
    public suspend fun dvbNitSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>) {
        this.dvbNitSettings = value
    }

    /**
     * @param value
     */
    @JvmName("qnelgxeohgoahidr")
    public suspend fun dvbSdtSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>) {
        this.dvbSdtSettings = value
    }

    /**
     * @param value
     */
    @JvmName("lywkortuafiwadlh")
    public suspend fun dvbSubPids(`value`: Output<String>) {
        this.dvbSubPids = value
    }

    /**
     * @param value
     */
    @JvmName("wqkydvjrhcirnrmv")
    public suspend fun dvbTdtSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>) {
        this.dvbTdtSettings = value
    }

    /**
     * @param value
     */
    @JvmName("hqokaqjykodkdhvr")
    public suspend fun dvbTeletextPid(`value`: Output<String>) {
        this.dvbTeletextPid = value
    }

    /**
     * @param value
     */
    @JvmName("ngkpdnuxafdljbov")
    public suspend fun ebif(`value`: Output<String>) {
        this.ebif = value
    }

    /**
     * @param value
     */
    @JvmName("irpykghpspkhiimk")
    public suspend fun ebpAudioInterval(`value`: Output<String>) {
        this.ebpAudioInterval = value
    }

    /**
     * @param value
     */
    @JvmName("uopnebtlndyrgvqm")
    public suspend fun ebpLookaheadMs(`value`: Output<Int>) {
        this.ebpLookaheadMs = value
    }

    /**
     * @param value
     */
    @JvmName("nicnynerljiglasp")
    public suspend fun ebpPlacement(`value`: Output<String>) {
        this.ebpPlacement = value
    }

    /**
     * @param value
     */
    @JvmName("tkxpvbcwcpdktpll")
    public suspend fun ecmPid(`value`: Output<String>) {
        this.ecmPid = value
    }

    /**
     * @param value
     */
    @JvmName("ntybbqejookjvgnc")
    public suspend fun esRateInPes(`value`: Output<String>) {
        this.esRateInPes = value
    }

    /**
     * @param value
     */
    @JvmName("xtslubhgupuahgyx")
    public suspend fun etvPlatformPid(`value`: Output<String>) {
        this.etvPlatformPid = value
    }

    /**
     * @param value
     */
    @JvmName("riaugsvyvmsbpiqg")
    public suspend fun etvSignalPid(`value`: Output<String>) {
        this.etvSignalPid = value
    }

    /**
     * @param value
     */
    @JvmName("vyffextodvrutkkc")
    public suspend fun fragmentTime(`value`: Output<Double>) {
        this.fragmentTime = value
    }

    /**
     * @param value
     */
    @JvmName("nnxnjooqsulfwejt")
    public suspend fun klv(`value`: Output<String>) {
        this.klv = value
    }

    /**
     * @param value
     */
    @JvmName("fypkeqidwpkewhni")
    public suspend fun klvDataPids(`value`: Output<String>) {
        this.klvDataPids = value
    }

    /**
     * @param value
     */
    @JvmName("qvwduugflhlwrrfh")
    public suspend fun nielsenId3Behavior(`value`: Output<String>) {
        this.nielsenId3Behavior = value
    }

    /**
     * @param value
     */
    @JvmName("bcasciyfygpfcyyq")
    public suspend fun nullPacketBitrate(`value`: Output<Double>) {
        this.nullPacketBitrate = value
    }

    /**
     * @param value
     */
    @JvmName("ipmowdtigqsuwpcs")
    public suspend fun patInterval(`value`: Output<Int>) {
        this.patInterval = value
    }

    /**
     * @param value
     */
    @JvmName("lerjahteselteogv")
    public suspend fun pcrControl(`value`: Output<String>) {
        this.pcrControl = value
    }

    /**
     * @param value
     */
    @JvmName("vcpjwfscoqfiispm")
    public suspend fun pcrPeriod(`value`: Output<Int>) {
        this.pcrPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("jvnpxiecxgbuhleu")
    public suspend fun pcrPid(`value`: Output<String>) {
        this.pcrPid = value
    }

    /**
     * @param value
     */
    @JvmName("ctjpclkkfyemnjxm")
    public suspend fun pmtInterval(`value`: Output<Int>) {
        this.pmtInterval = value
    }

    /**
     * @param value
     */
    @JvmName("quibjaspbmhrkvog")
    public suspend fun pmtPid(`value`: Output<String>) {
        this.pmtPid = value
    }

    /**
     * @param value
     */
    @JvmName("svwkcjfsueqqdhrr")
    public suspend fun programNum(`value`: Output<Int>) {
        this.programNum = value
    }

    /**
     * @param value
     */
    @JvmName("wtjvbirjunjlnqtl")
    public suspend fun rateMode(`value`: Output<String>) {
        this.rateMode = value
    }

    /**
     * @param value
     */
    @JvmName("mnotkqkwiondicrt")
    public suspend fun scte27Pids(`value`: Output<String>) {
        this.scte27Pids = value
    }

    /**
     * @param value
     */
    @JvmName("jxbulpxpsmcmhijf")
    public suspend fun scte35Control(`value`: Output<String>) {
        this.scte35Control = value
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("qbfyocupsdqknujx")
    public suspend fun scte35Pid(`value`: Output<String>) {
        this.scte35Pid = value
    }

    /**
     * @param value
     */
    @JvmName("fjpfhhmuppbbiihd")
    public suspend fun segmentationMarkers(`value`: Output<String>) {
        this.segmentationMarkers = value
    }

    /**
     * @param value
     */
    @JvmName("jgkpbawkwjgnpfxl")
    public suspend fun segmentationStyle(`value`: Output<String>) {
        this.segmentationStyle = value
    }

    /**
     * @param value
     */
    @JvmName("tystlmnqgevuehim")
    public suspend fun segmentationTime(`value`: Output<Double>) {
        this.segmentationTime = value
    }

    /**
     * @param value
     */
    @JvmName("nhicqihoocmpfnml")
    public suspend fun timedMetadataBehavior(`value`: Output<String>) {
        this.timedMetadataBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("gjehbekutniyrveh")
    public suspend fun timedMetadataPid(`value`: Output<String>) {
        this.timedMetadataPid = value
    }

    /**
     * @param value
     */
    @JvmName("kpbdgmbbhdthqbef")
    public suspend fun transportStreamId(`value`: Output<Int>) {
        this.transportStreamId = value
    }

    /**
     * @param value
     */
    @JvmName("temhitwjrkevnssa")
    public suspend fun videoPid(`value`: Output<String>) {
        this.videoPid = value
    }

    /**
     * @param value
     */
    @JvmName("uejtwmuvetyjiilf")
    public suspend fun absentInputAudioBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.absentInputAudioBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvgwpiewhougvcws")
    public suspend fun arib(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arib = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewniyfitgasaslpn")
    public suspend fun aribCaptionsPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribCaptionsPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbxewvuqxsfcotkx")
    public suspend fun aribCaptionsPidControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribCaptionsPidControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsghotopimrmutej")
    public suspend fun audioBufferModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioBufferModel = mapped
    }

    /**
     * @param value
     */
    @JvmName("ldbudyprfemkbcfh")
    public suspend fun audioFramesPerPes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioFramesPerPes = mapped
    }

    /**
     * @param value
     */
    @JvmName("dwuxqobkkccuicue")
    public suspend fun audioPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("okfwoscuxpjxkufr")
    public suspend fun audioStreamType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioStreamType = mapped
    }

    /**
     * @param value
     */
    @JvmName("yptpnuelnloogvys")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("igjysvjtbdtjoker")
    public suspend fun bufferModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferModel = mapped
    }

    /**
     * @param value
     */
    @JvmName("yhpmlssfckcwjqoj")
    public suspend fun ccDescriptor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccDescriptor = mapped
    }

    /**
     * @param value
     */
    @JvmName("hlqgpyxymovjbprj")
    public suspend fun dvbNitSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbNitSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gpbausdgkyjdeqpv")
    public suspend fun dvbNitSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbNitSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("ahttemggxvrkrljj")
    public suspend fun dvbSdtSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSdtSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ysmemmqsodnhnbdp")
    public suspend fun dvbSdtSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbSdtSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrobavhppcqbcmvy")
    public suspend fun dvbSubPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSubPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("syuiagatquportsy")
    public suspend fun dvbTdtSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbTdtSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpeekpyarayueldh")
    public suspend fun dvbTdtSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbTdtSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("lypfcqsbfxhosukj")
    public suspend fun dvbTeletextPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbTeletextPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("dlwmgpvgxjupbbyv")
    public suspend fun ebif(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebif = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijdtuoxfdmdxfief")
    public suspend fun ebpAudioInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpAudioInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("gxgccfhcpmaejbjw")
    public suspend fun ebpLookaheadMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpLookaheadMs = mapped
    }

    /**
     * @param value
     */
    @JvmName("xkhhhqotcicjcvxp")
    public suspend fun ebpPlacement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpPlacement = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvrkqcbylwihktkn")
    public suspend fun ecmPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecmPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmdjwtrfgimhhgat")
    public suspend fun esRateInPes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.esRateInPes = mapped
    }

    /**
     * @param value
     */
    @JvmName("hoflfnmjssotbiyh")
    public suspend fun etvPlatformPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etvPlatformPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("urahspaxeaakxieh")
    public suspend fun etvSignalPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etvSignalPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("neyfuqfemjkrdryi")
    public suspend fun fragmentTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fragmentTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("yfybfooiunohxyay")
    public suspend fun klv(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.klv = mapped
    }

    /**
     * @param value
     */
    @JvmName("miufsuopehvftuyx")
    public suspend fun klvDataPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.klvDataPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("lnjnvrulfxtertiw")
    public suspend fun nielsenId3Behavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenId3Behavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("nebdgduwewmjdqnr")
    public suspend fun nullPacketBitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nullPacketBitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcqygxcwnhsejlph")
    public suspend fun patInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxoqyediqvnphsyt")
    public suspend fun pcrControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("emuiysikydktsgtr")
    public suspend fun pcrPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtdjjerpfxpixema")
    public suspend fun pcrPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("kphyvrkyddwpkhlc")
    public suspend fun pmtInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxgfbmjxllgeiafg")
    public suspend fun pmtPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxalaftyfnxhhkqm")
    public suspend fun programNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programNum = mapped
    }

    /**
     * @param value
     */
    @JvmName("ycpubvcqqvoerici")
    public suspend fun rateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("qqoribtawljohmne")
    public suspend fun scte27Pids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte27Pids = mapped
    }

    /**
     * @param value
     */
    @JvmName("ttvurugqjayhfumf")
    public suspend fun scte35Control(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Control = mapped
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("fqhbmuxoopgwxwkr")
    public suspend fun scte35Pid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Pid = mapped
    }

    /**
     * @param value
     */
    @JvmName("xbrkhmyvkqalnqwb")
    public suspend fun segmentationMarkers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationMarkers = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydxmbhiudollqloo")
    public suspend fun segmentationStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationStyle = mapped
    }

    /**
     * @param value
     */
    @JvmName("axhjvovqodyybgcq")
    public suspend fun segmentationTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("qyhnbflsjlcmpylw")
    public suspend fun timedMetadataBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("xpcsrooacylyypqf")
    public suspend fun timedMetadataPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("vlofsgsolfkefiho")
    public suspend fun transportStreamId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportStreamId = mapped
    }

    /**
     * @param value
     */
    @JvmName("wtltfacrrqulfstj")
    public suspend fun videoPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoPid = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs(
            absentInputAudioBehavior = absentInputAudioBehavior,
            arib = arib,
            aribCaptionsPid = aribCaptionsPid,
            aribCaptionsPidControl = aribCaptionsPidControl,
            audioBufferModel = audioBufferModel,
            audioFramesPerPes = audioFramesPerPes,
            audioPids = audioPids,
            audioStreamType = audioStreamType,
            bitrate = bitrate,
            bufferModel = bufferModel,
            ccDescriptor = ccDescriptor,
            dvbNitSettings = dvbNitSettings,
            dvbSdtSettings = dvbSdtSettings,
            dvbSubPids = dvbSubPids,
            dvbTdtSettings = dvbTdtSettings,
            dvbTeletextPid = dvbTeletextPid,
            ebif = ebif,
            ebpAudioInterval = ebpAudioInterval,
            ebpLookaheadMs = ebpLookaheadMs,
            ebpPlacement = ebpPlacement,
            ecmPid = ecmPid,
            esRateInPes = esRateInPes,
            etvPlatformPid = etvPlatformPid,
            etvSignalPid = etvSignalPid,
            fragmentTime = fragmentTime,
            klv = klv,
            klvDataPids = klvDataPids,
            nielsenId3Behavior = nielsenId3Behavior,
            nullPacketBitrate = nullPacketBitrate,
            patInterval = patInterval,
            pcrControl = pcrControl,
            pcrPeriod = pcrPeriod,
            pcrPid = pcrPid,
            pmtInterval = pmtInterval,
            pmtPid = pmtPid,
            programNum = programNum,
            rateMode = rateMode,
            scte27Pids = scte27Pids,
            scte35Control = scte35Control,
            scte35Pid = scte35Pid,
            segmentationMarkers = segmentationMarkers,
            segmentationStyle = segmentationStyle,
            segmentationTime = segmentationTime,
            timedMetadataBehavior = timedMetadataBehavior,
            timedMetadataPid = timedMetadataPid,
            transportStreamId = transportStreamId,
            videoPid = videoPid,
        )
}
