@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audioFramesPerPes
 * @property audioPids
 * @property ecmPid
 * @property nielsenId3Behavior
 * @property patInterval
 * @property pcrControl
 * @property pcrPeriod
 * @property pcrPid
 * @property pmtInterval
 * @property pmtPid
 * @property programNum
 * @property scte35Behavior
 * @property scte35Pid PID from which to read SCTE-35 messages.
 * @property timedMetadataBehavior
 * @property timedMetadataPid
 * @property transportStreamId
 * @property videoPid
 */
public data class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs(
    public val audioFramesPerPes: Output<Int>? = null,
    public val audioPids: Output<String>? = null,
    public val ecmPid: Output<String>? = null,
    public val nielsenId3Behavior: Output<String>? = null,
    public val patInterval: Output<Int>? = null,
    public val pcrControl: Output<String>? = null,
    public val pcrPeriod: Output<Int>? = null,
    public val pcrPid: Output<String>? = null,
    public val pmtInterval: Output<Int>? = null,
    public val pmtPid: Output<String>? = null,
    public val programNum: Output<Int>? = null,
    public val scte35Behavior: Output<String>? = null,
    public val scte35Pid: Output<String>? = null,
    public val timedMetadataBehavior: Output<String>? = null,
    public val timedMetadataPid: Output<String>? = null,
    public val transportStreamId: Output<Int>? = null,
    public val videoPid: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs.builder()
            .audioFramesPerPes(audioFramesPerPes?.applyValue({ args0 -> args0 }))
            .audioPids(audioPids?.applyValue({ args0 -> args0 }))
            .ecmPid(ecmPid?.applyValue({ args0 -> args0 }))
            .nielsenId3Behavior(nielsenId3Behavior?.applyValue({ args0 -> args0 }))
            .patInterval(patInterval?.applyValue({ args0 -> args0 }))
            .pcrControl(pcrControl?.applyValue({ args0 -> args0 }))
            .pcrPeriod(pcrPeriod?.applyValue({ args0 -> args0 }))
            .pcrPid(pcrPid?.applyValue({ args0 -> args0 }))
            .pmtInterval(pmtInterval?.applyValue({ args0 -> args0 }))
            .pmtPid(pmtPid?.applyValue({ args0 -> args0 }))
            .programNum(programNum?.applyValue({ args0 -> args0 }))
            .scte35Behavior(scte35Behavior?.applyValue({ args0 -> args0 }))
            .scte35Pid(scte35Pid?.applyValue({ args0 -> args0 }))
            .timedMetadataBehavior(timedMetadataBehavior?.applyValue({ args0 -> args0 }))
            .timedMetadataPid(timedMetadataPid?.applyValue({ args0 -> args0 }))
            .transportStreamId(transportStreamId?.applyValue({ args0 -> args0 }))
            .videoPid(videoPid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgsBuilder
internal constructor() {
    private var audioFramesPerPes: Output<Int>? = null

    private var audioPids: Output<String>? = null

    private var ecmPid: Output<String>? = null

    private var nielsenId3Behavior: Output<String>? = null

    private var patInterval: Output<Int>? = null

    private var pcrControl: Output<String>? = null

    private var pcrPeriod: Output<Int>? = null

    private var pcrPid: Output<String>? = null

    private var pmtInterval: Output<Int>? = null

    private var pmtPid: Output<String>? = null

    private var programNum: Output<Int>? = null

    private var scte35Behavior: Output<String>? = null

    private var scte35Pid: Output<String>? = null

    private var timedMetadataBehavior: Output<String>? = null

    private var timedMetadataPid: Output<String>? = null

    private var transportStreamId: Output<Int>? = null

    private var videoPid: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yedlfyskmrtflvud")
    public suspend fun audioFramesPerPes(`value`: Output<Int>) {
        this.audioFramesPerPes = value
    }

    /**
     * @param value
     */
    @JvmName("jqddglamgssecbvw")
    public suspend fun audioPids(`value`: Output<String>) {
        this.audioPids = value
    }

    /**
     * @param value
     */
    @JvmName("eeoihopslusmdvhm")
    public suspend fun ecmPid(`value`: Output<String>) {
        this.ecmPid = value
    }

    /**
     * @param value
     */
    @JvmName("advslytagnxetehw")
    public suspend fun nielsenId3Behavior(`value`: Output<String>) {
        this.nielsenId3Behavior = value
    }

    /**
     * @param value
     */
    @JvmName("xsnlhvtxknoxbfyf")
    public suspend fun patInterval(`value`: Output<Int>) {
        this.patInterval = value
    }

    /**
     * @param value
     */
    @JvmName("wfmjjuxhohxqyfpg")
    public suspend fun pcrControl(`value`: Output<String>) {
        this.pcrControl = value
    }

    /**
     * @param value
     */
    @JvmName("onuqtyswipwvqydj")
    public suspend fun pcrPeriod(`value`: Output<Int>) {
        this.pcrPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("wldsuagjtsfrxhen")
    public suspend fun pcrPid(`value`: Output<String>) {
        this.pcrPid = value
    }

    /**
     * @param value
     */
    @JvmName("cruhibnalclwggag")
    public suspend fun pmtInterval(`value`: Output<Int>) {
        this.pmtInterval = value
    }

    /**
     * @param value
     */
    @JvmName("yuiujkystcgryqnk")
    public suspend fun pmtPid(`value`: Output<String>) {
        this.pmtPid = value
    }

    /**
     * @param value
     */
    @JvmName("vjhltxdhaotmpmrg")
    public suspend fun programNum(`value`: Output<Int>) {
        this.programNum = value
    }

    /**
     * @param value
     */
    @JvmName("cgyqjrqvgaqcwdim")
    public suspend fun scte35Behavior(`value`: Output<String>) {
        this.scte35Behavior = value
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("aqxosxdwgyespfwb")
    public suspend fun scte35Pid(`value`: Output<String>) {
        this.scte35Pid = value
    }

    /**
     * @param value
     */
    @JvmName("wstpbbrkjufokjkh")
    public suspend fun timedMetadataBehavior(`value`: Output<String>) {
        this.timedMetadataBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("rokagfqmcuuudosr")
    public suspend fun timedMetadataPid(`value`: Output<String>) {
        this.timedMetadataPid = value
    }

    /**
     * @param value
     */
    @JvmName("pjugfpmqysgvjaqv")
    public suspend fun transportStreamId(`value`: Output<Int>) {
        this.transportStreamId = value
    }

    /**
     * @param value
     */
    @JvmName("ibxrwgpjlqxysgav")
    public suspend fun videoPid(`value`: Output<String>) {
        this.videoPid = value
    }

    /**
     * @param value
     */
    @JvmName("btxohqqcoxnsdajr")
    public suspend fun audioFramesPerPes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioFramesPerPes = mapped
    }

    /**
     * @param value
     */
    @JvmName("oxoprtcovvmbrpuj")
    public suspend fun audioPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvjksyvlkfsgsbkq")
    public suspend fun ecmPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecmPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("ampdubcdjfnhiqbm")
    public suspend fun nielsenId3Behavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenId3Behavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("ncwomvhiirqqrhxh")
    public suspend fun patInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("lhmopdknuwugwlsa")
    public suspend fun pcrControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("pymywwxckesaowup")
    public suspend fun pcrPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghydjqsvytqxguix")
    public suspend fun pcrPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("bgtookbkftkornff")
    public suspend fun pmtInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("lponprhywqvraolx")
    public suspend fun pmtPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("mlyuotfwitcxeesg")
    public suspend fun programNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programNum = mapped
    }

    /**
     * @param value
     */
    @JvmName("fcdvjlxkeruwyrhk")
    public suspend fun scte35Behavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Behavior = mapped
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("vnqabndbhlbdahgi")
    public suspend fun scte35Pid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Pid = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjpdpcbnkcmagycj")
    public suspend fun timedMetadataBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("btggkwcshpghikqj")
    public suspend fun timedMetadataPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("ttknoflcalfupmjw")
    public suspend fun transportStreamId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportStreamId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlesglldngyxccfu")
    public suspend fun videoPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoPid = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsStandardHlsSettingsM3u8SettingsArgs(
            audioFramesPerPes = audioFramesPerPes,
            audioPids = audioPids,
            ecmPid = ecmPid,
            nielsenId3Behavior = nielsenId3Behavior,
            patInterval = patInterval,
            pcrControl = pcrControl,
            pcrPeriod = pcrPeriod,
            pcrPid = pcrPid,
            pmtInterval = pmtInterval,
            pmtPid = pmtPid,
            programNum = programNum,
            scte35Behavior = scte35Behavior,
            scte35Pid = scte35Pid,
            timedMetadataBehavior = timedMetadataBehavior,
            timedMetadataPid = timedMetadataPid,
            transportStreamId = transportStreamId,
            videoPid = videoPid,
        )
}
